#ifndef _UppGL_UppGL_h_
#define _UppGL_UppGL_h_

#define byte win32_byte_
#include <windows.h>
#include <GL/glee.h>
#undef byte
#include <GL/glu.h>

// Last resort
#define NO_MOVEABLE_CHECK

#include <CtrlLib/CtrlLib.h>
#include <GLCtrl/GlCtrl.h>
using namespace Upp;

// Maths
#include "glm.h"
#include "Angle.h"

struct VertexPNT {
	Vec3f position;
	Vec3f normal;
	Vec2f texture0;
	void Serialize(Stream &s) { s % position % normal % texture0; }
};
typedef VertexPNT Vertex;
NTL_MOVEABLE(VertexPNT);

// GL encapsulation
#include "ManagedResource.h"
#include "Colorf.h"
#include "Primitive.h"
#include "GLEnable.h"
// Camera/view
#include "Camera.h"
#include "Frustum.h"
#include "GLViewCtrl.h"
// Material/Texture
#include "ShaderProgram.h"
#include "Texture.h"
#include "Material.h"
#include "Mesh.h"
#include "PackingTree.h"
#include "RenderTexture.h"
//Util
#include "SubDivider.h"
#include "SkyDome.h"
#include "PerlinNoise.h"
#include "RenderChain.h"

#define IF_DEBUG if (IsDebug()) {
#define	END_DEBUG }
void 	SetDebugMode();
bool	IsDebug();

// Global camera/frustum
Camera&		GetCamera();
void		SetCamera(Camera &camera);	
bool		HasCamera();	
Frustum&	GetFrustum();
void		SetFrustum(Frustum &frustum);	
bool		HasFrustum();
float 		GetFrustumFOVDelta();
void		SetFrustumFOVDelta(float fov);
// Lights	
GLLight&	GetLight0();
void		SetLight0(GLLight &light);		
// Shaders
bool		UseShaders();
void		EnableShaders(bool v);
// Bump mapping
bool		UseBumpMapping();
void		EnableBumpMapping(bool v);
// Misc
bool 		IsKey(KeyInfo &info, dword key);
bool		ShaderSupport();
bool 		FBOSupport();
// Error handling
String 		LastGLError();
void		GLClearError();
void 		GLError(String s);
bool 		GLErrorF(String s);
String 		GLErrorS(String s);
int 		GLErrorI(String s, int v);
bool		IsGLError();
void		GLLog(const String &s);

#define GLRLogErrors() { \
	GLenum err = glGetError(); \
	while (err != GL_NO_ERROR) { \
		GLLog(Format("glError: %s caught at %s:%d\n", (char *)gluErrorString(err), __FILE__, __LINE__)); \
		err = glGetError(); \
	} \
}

#define GLLogErrors() if (IsDebug()) { GLRLogErrors(); }

// Local files
void 		SetLocalFileRoot(const char *root);
String 		LocalDir();
String 		LocalFile(String file);
// Resource paths
String 		GetFullPath(int id,  const String &path);
void		SetFullPath(int id,  const String &path);
void		SetLocalPath(int id, const String &path);
enum 		{ MESH_PATH = 0, TEXTURE_PATH = 1, SHADER_PATH = 2, MATERIAL_PATH = 3, DATA_PATH = 4, APP_PATH = 5 };

Vec3f GetNormal(const Vec3f &a, const Vec3f &b, const Vec3f &c);
Vec3f GetNormal(const Triangle32 &t, Vector<Vec3f> &v);
Vec3f GetNormal(const Triangle16 &t, Vector<Vec3f> &v);

// VBO functions
template <class T>	
GLuint CreateIBO(const Vector<T> &data) 
	{ return CreateVBOSub(data, data.GetCount(), GL_ELEMENT_ARRAY_BUFFER_ARB); }
template <class T>	
GLuint CreateIBOSub(const Vector<T> &data, int cnt) 
	{ return CreateVBOSub(data, cnt, GL_ELEMENT_ARRAY_BUFFER_ARB); }

template <class T>
GLuint CreateVBO(const Vector<T> &data, GLenum type = GL_ARRAY_BUFFER_ARB, GLenum access = GL_STATIC_DRAW_ARB)
	{ return CreateVBOSub(data, data.GetCount(), type, access); }
template <class T>
GLuint CreateVBOSub(const Vector<T> &data, int cnt, GLenum type = GL_ARRAY_BUFFER_ARB, GLenum access = GL_STATIC_DRAW_ARB)
{
	GLuint vboid;
	glGenBuffersARB(1, &vboid );		// Get A Valid ID
	glBindBufferARB(type, vboid);		// Bind The Buffer
	// Load The Data
	glBufferDataARB(type, cnt*sizeof(T), &data[0], access);
	return vboid;
}
template <class T>
void UpdateVBO(GLuint vboid, const Vector<T> &data, GLenum type = GL_ARRAY_BUFFER_ARB, GLenum access = GL_STATIC_DRAW_ARB)
{
	glBindBuffer(type, vboid);
	glBufferDataARB(type, 0, NULL, access);
	glBufferDataARB(type, data.GetCount()*sizeof(T), &data[0], access);
	// Load The Data
//	glBufferSubDataARB(vboid, offset*sizeof(T), data.GetCount()*sizeof(T), &data[0]);
}
void DestroyVBO(GLuint vboid);

void RenderAxis(float size = 100.0f, bool depthtest = false);
void RenderBox(const Box &box, bool depthtest = true);
void RenderZPlane(float sz);

#endif
