#define GLM_USE_ONLY_XYZW

#include <glm/glm.hpp>
#include <glm/gtc.hpp>

typedef glm::fvec2 Vec2f;
typedef glm::fvec3 Vec3f;
typedef glm::fvec4 Vec4f;

typedef glm::ivec2 Vec2i;
typedef glm::ivec3 Vec3i;
typedef glm::ivec4 Vec4i;

typedef glm::fmat2 Mat2f;
typedef glm::fmat3 Mat3f;
typedef glm::fmat4 Mat4f;

NTL_MOVEABLE(Vec2f);
NTL_MOVEABLE(Vec3f);
NTL_MOVEABLE(Vec4f);

NTL_MOVEABLE(Vec2i);
NTL_MOVEABLE(Vec3i);
NTL_MOVEABLE(Vec4i);

NTL_MOVEABLE(Mat2f);
NTL_MOVEABLE(Mat3f);
NTL_MOVEABLE(Mat4f);

inline float* operator~(Vec2f &v) 					{ return &v.x; }
inline const float* operator~(const Vec2f &v) 		{ return &v.x; }
inline float* operator~(Vec3f &v) 					{ return &v.x; }
inline const float* operator~(const Vec3f &v) 		{ return &v.x; }
inline float* operator~(Vec4f &v) 					{ return &v.x; }
inline const float* operator~(const Vec4f &v) 		{ return &v.x; }

inline int* operator~(Vec2i &v) 					{ return &v.x; }
inline const int* operator~(const Vec2i &v) 		{ return &v.x; }
inline int* operator~(Vec3i &v) 					{ return &v.x; }
inline const int* operator~(const Vec3i &v) 		{ return &v.x; }
inline int* operator~(Vec4i &v) 					{ return &v.x; }
inline const int* operator~(const Vec4i &v) 		{ return &v.x; }

inline float* operator~(Mat2f &m) 					{ return &m[0].x; }
inline const float* operator~(const Mat2f &m) 		{ return &m[0].x; }
inline float* operator~(Mat3f &m) 					{ return &m[0].x; }
inline const float* operator~(const Mat3f &m) 		{ return &m[0].x; }
inline float* operator~(Mat4f &m) 					{ return &m[0].x; }
inline const float* operator~(const Mat4f &m) 		{ return &m[0].x; }

inline Stream &operator%(Stream &s, Vec2f &v)		{ return s % v.x % v.y; }
inline Stream &operator%(Stream &s, Vec3f &v)		{ return s % v.x % v.y % v.z; }
inline Stream &operator%(Stream &s, Vec4f &v)		{ return s % v.x % v.y % v.z % v.w; }

inline Stream &operator%(Stream &s, Vec2i &v)		{ return s % v.x % v.y; }
inline Stream &operator%(Stream &s, Vec3i &v)		{ return s % v.x % v.y % v.z; }
inline Stream &operator%(Stream &s, Vec4i &v)		{ return s % v.x % v.y % v.z % v.w; }

inline Stream &operator%(Stream &s, Mat2f &m)		{ return s % m[0] % m[1]; }
inline Stream &operator%(Stream &s, Mat3f &m)		{ return s % m[0] % m[1] % m[2]; }
inline Stream &operator%(Stream &s, Mat4f &m)		{ return s % m[0] % m[1] % m[2] % m[3]; }

inline Vec3f operator*(const Mat4f &m, const Vec3f & v)
{
	NEVER();
    return Vec3f(
        m[0][0] * v.x + m[1][0] * v.y + m[2][0] * v.z,
        m[0][1] * v.x + m[1][1] * v.y + m[2][1] * v.z,
        m[0][2] * v.x + m[1][2] * v.y + m[2][2] * v.z);
}
inline Vec3f operator*(const Vec3f &v,  const Mat4f & m)
{
    return Vec3f(m[0][0] * v.x + m[0][1] * v.y + m[0][2] * v.z,
        m[1][0] * v.x + m[1][1] * v.y + m[1][2] * v.z,
        m[2][0] * v.x + m[2][1] * v.y + m[2][2] * v.z);
}
inline Vec3f &operator*=(Vec3f &v, const Mat4f &m) { return (v = v * m); }

inline Vec2f operator*(const Vec2f &v1, const Vec2f &v2) { return Vec2f(v1.x*v2.x, v1.y*v2.y); }
inline Vec3f operator*(const Vec3f &v1, const Vec3f &v2) { return Vec3f(v1.x*v2.x, v1.y*v2.y, v1.z*v2.z); }
inline Vec4f operator*(const Vec4f &v1, const Vec4f &v2) { return Vec4f(v1.x*v2.x, v1.y*v2.y, v1.z*v2.z, v1.w*v2.w); }

inline String AsString(const Vec3f &p);
inline String AsString(const Vec3i &p);

struct Vector3f : public Vector<Vec3f> {
	void     Serialize(Stream& s)    { StreamContainer(s); }	
	void StreamContainer(Stream& s)
	{
		int n = GetCount();
		s / n;
		if(n < 0) {
			s.LoadError();
			return;
		}
		if(s.IsLoading())
		{
			Clear();
			while(n--)
				s % Add();
		}
		else
		{
			for(Iterator ptr = Begin(); n--; ++ptr)
				s % *ptr;
		}
	}	
};

#define X_AXIS Vec3f(1.0f, 0.0f, 0.0f)
#define Y_AXIS Vec3f(0.0f, 1.0f, 0.0f)
#define Z_AXIS Vec3f(0.0f, 0.0f, 1.0f)