///////////////////////////////////////////////////////////////////////////////////////////////////
// OpenGL Mathematics Copyright (c) 2005 - 2009 G-Truc Creation (www.g-truc.net)
///////////////////////////////////////////////////////////////////////////////////////////////////
// Created : 2005-12-21
// Updated : 2006-11-13
// Licence : This source is under MIT licence
// File    : glm/gtx/vector_comp_mult.h
///////////////////////////////////////////////////////////////////////////////////////////////////
// Dependency:
// - GLM core
///////////////////////////////////////////////////////////////////////////////////////////////////
// Note:
// mat4 m;
// vec4 v;
// ...
// vec4 Result = transposeGTX(m) * v;
// Same result as the following, but it's faster by avoiding the matrix transpose: 
// vec4 Result = vectorCompMultGTX(m, v);
///////////////////////////////////////////////////////////////////////////////////////////////////
// Note:
// - This extension is deprecated, use the operator vec* * mat* instead.
///////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef glm_gtx_vector_comp_mult
#define glm_gtx_vector_comp_mult

// Dependency:
#include "../glm.hpp"

namespace glm
{
    template <typename T> detail::tvec2<T> vectorCompMultGTX(const detail::tmat2x2<T>& x, const detail::tvec2<T>& y); //!< Deprecated: Prefer vec2 * mat2 operator (From GLM_GTX_vector_comp_mult extension)
    template <typename T> detail::tvec3<T> vectorCompMultGTX(const detail::tmat3x3<T>& x, const detail::tvec3<T>& y); //!< Deprecated: Prefer vec3 * mat3 operator (From GLM_GTX_vector_comp_mult extension)
    template <typename T> detail::tvec4<T> vectorCompMultGTX(const detail::tmat4x4<T>& x, const detail::tvec4<T>& y); //!< Deprecated: Prefer vec4 * mat4 operator (From GLM_GTX_vector_comp_mult extension)

    namespace gtx
    {
		//! GLM_GTX_vector_comp_mult extension: Deprecated: Use revert vector matrix product instead
        namespace vector_comp_mult
        {
            template <typename T> inline detail::tvec2<T> vectorCompMult(const detail::tmat2x2<T>& x, const detail::tvec2<T>& y){return vectorCompMultGTX(x, y);} //!< Deprecated: Prefer vec2 * mat2 operator (From GLM_GTX_vector_comp_mult extension)
            template <typename T> inline detail::tvec3<T> vectorCompMult(const detail::tmat3x3<T>& x, const detail::tvec3<T>& y){return vectorCompMultGTX(x, y);} //!< Deprecated: Prefer vec3 * mat3 operator (From GLM_GTX_vector_comp_mult extension)
            template <typename T> inline detail::tvec4<T> vectorCompMult(const detail::tmat4x4<T>& x, const detail::tvec4<T>& y){return vectorCompMultGTX(x, y);} //!< Deprecated: Prefer vec4 * mat4 operator (From GLM_GTX_vector_comp_mult extension)
        }
    }
}

#define GLM_GTX_vector_comp_mult namespace gtx::vector_comp_mult
#ifndef GLM_GTX_GLOBAL
namespace glm {using GLM_GTX_vector_comp_mult;}
#endif//GLM_GTX_GLOBAL

#include "vector_comp_mult.inl"

#endif//glm_gtx_vector_comp_mult
