#ifndef PI
#define PI 3.14159265
#endif

#ifndef TWOPI
#define TWOPI 6.2831853
#endif

#define DEG_TO_RAD(deg) ((float)((deg)*PI/180.0))
#define RAD_TO_DEG(rad) ((float)((rad)*180.0/PI))
#define DEG_TO_RADd(deg) (deg*PI/180.0)
#define RAD_TO_DEGd(rad) (rad*180.0/PI)

#define ANGLE_CACHE_SIZE 511
float QuickSin(int i); 
float QuickCos(int i);
float QuickAngleToRad(int i);
float QuickAngleToDeg(int i);
int   DegToQuickAngle(int i);
int   DegToQuickAngle(int i);

inline void QRotateZ(Vec3f &p, float qsin, float qcos) 
{
	float x = qcos * p.x + qsin * p.y;
	p.y = qcos * p.y - qsin * p.x;
	p.x = x;	
}
inline void QRotateZ(Vec2f &p, float qsin, float qcos) 
{
	float x = qcos * p.x + qsin * p.y;
	p.y = qcos * p.y - qsin * p.x;
	p.x = x;	
}
inline void QRotateZ(Vec3f &p, int anglep)	{ QRotateZ(p, QuickSin(anglep), QuickCos(anglep)); }