#include<UppGL/UppGl.h>

#ifndef CAMERA_KEYGROUP
#define CAMERA_KEYGROUP "Camera"
#endif

#define KEYNAMESPACE CameraKeys
#define KEYGROUPNAME CAMERA_KEYGROUP		
#define KEYFILE      <UppGL/FPSCamera/FPSCamera.key>		
#include <CtrlLib/key_header.h>

struct FPSCamera : public Camera, Moveable<FPSCamera>
{
	Vec3f 	fpsup;
	bool	isomove;
	bool	inverty;
	bool 	locky;
protected:
	virtual bool Key(dword key, int count);
	virtual bool MouseDrag(Point dif, dword keyflags);
	virtual bool MouseWheel(Point p, int zdelta, dword keyflags);		
public:
	Callback WhenMove;

	FPSCamera() : fpsup(Z_AXIS), isomove(false), inverty(false), locky(false) {}
	
	FPSCamera &SetUpAxis(Vec3f axis) { fpsup = axis; return *this; }	
	void LockYAxis(bool v = true)		{ locky = v; }
	void InvertYAxis(bool v = true)		{ inverty = v; }
	void IsometricMove(bool v = true)	{ isomove = v; }
};