#include "UppGL.h"

class Plane 
{
public:
	Vec3f normal, point;
	float d;

	Plane::Plane(const Vec3f &v1, const Vec3f &v2, const Vec3f &v3);
	Plane::Plane(void);
	Plane::~Plane();

	void Set3Points(const Vec3f &v1, const Vec3f &v2, const Vec3f &v3);
	void SetNormalAndPoint(const Vec3f &normal, const Vec3f &point);
	void SetCoefficients(float a, float b, float c, float d);
	float Distance(const Vec3f &p);
};

class Frustum
{
private:
	enum {
		TOP = 0,
		BOTTOM,
		LEFT,
		RIGHT,
		NEARP,
		FARP
	};
	
private:
	struct Line : public Moveable<Line>
	{
		Vec3f start;
		Vec3f unit;
		float length;	
		float zdiv;
		
		void Set(Vec3f &a, Vec3f &b) { 
			start = a; 
			unit = b - a; 
			length = glm::length(unit); 
			unit *= (1.0f / length); 
			zdiv = (unit.z == 0.0f) ? 0.0f : (1.0f / unit.z); 
		}
		void Set(Vec3f &a, Vec3f &b, float l) { 
			start = a; 
			unit = b - a; 
			length = l; 
			unit *= (1.0f / length); 
			zdiv = (unit.z == 0.0f) ? 0.0f : (1.0f / unit.z); 
		}
	};

	Plane pl[6];
	Vec3f ntl, ntr, nbl, nbr, ftl, ftr, fbl, fbr,
			X, Y, Z, camPos;
	float nearD, farD, ratio, angle;
	float sphereFactorX, sphereFactorY;
	float tang;
	float nw,nh,fw,fh;
	Vector3f	 	points;
	Vector<Line>	lines;
	bool dirty;
public:
	enum { OUTSIDE = 0, INTERSECT = 2, INSIDE = 1 };

	Frustum();
	~Frustum();

	void 	Dirty(bool v = true)	{ dirty = v; }
	bool 	IsDirty() const			{ return dirty; }

	void 	SetFrustum(const float *m);
	void 	SetProjection(float angle, float ratio, float nearD, float farD);
	void 	SetCamera(const Vec3f &position, const Vec3f &x, const Vec3f &y, const Vec3f &z);
	void	CalcPoints();
	void	CalcNearPoints();
	void	CalcFarPoints();
	void	CalcLines();
	void	CalcPlanes();
	
	int 	PointInFrustum(const Vec3f &p) const;
	int 	SphereInFrustum(const Vec3f &p, float radius)  const;
	int 	InclusiveSphereInFrustum(const Vec3f &p, float radius)  const;
	int		ZPlaneIntersect(Vector<Vec2f> &pt, float z);
	inline bool	ZLinePlaneInstersect(const Line &line, float z, Vec2f &out);

	Vector<Vec3f> &GetPoints() { return points; };
	void 	DrawPoints() const;
	void 	DrawLines() const;
	void 	DrawPlanes() const;
	void 	DrawNormals() const;
};
