class GLViewCtrl : public GLCtrl
{
	typedef GLViewCtrl CLASSNAME;
public:
	virtual void LeftDrag(Point p, dword keyflags);
	virtual void LeftUp(Point p, dword keyflags);
	virtual void MouseMove(Point p, dword keyflags);
	virtual void MouseWheel(Point p, int zdelta, dword keyflags);
	virtual bool Key(dword key, int count);
	virtual Image CursorImage(Point p, dword keyflags);
	
	virtual void GLRefresh()			{ GetFirstChild()->Refresh(); }
	virtual void GLResize(int w, int h);
	virtual void GLInit()				{ WhenGLInit(); }
public:
	Callback WhenGLInit;
	Callback WhenGLCameraMove;
	GLViewCtrl();

	void SetClearColor(float r, float g, float b, float a = 1.0f);
	void ClearColor();
	const float *GetClearColor() const 		{ return clearcolor; }
	
	void	ShareLists(GLCtrl &target)  	{ ShareLists(target.GetRC()); }
	void	ShareLists(HGLRC targethrc)		{ wglShareLists(GetRC(), targethrc); }
	void 	StartDC() const					{ wglMakeCurrent(GetDC(), GetRC()); }
	void 	StopDC() const					{ wglMakeCurrent(NULL, NULL); }
	
	void 	FrameTimerStart()				{ frametime = GetTickCount(); }
	void 	FrameTimerEnd()					{ frametime = GetTickCount() - frametime; }	
	int 	GetFrameTime() const			{ return frametime; }
	double	GetFPS() const					{ return frametime ? 1000.0 / frametime : 0.0f; }
	
	void 	EnableVerticalSync(bool enable);
	void	EnableMultiSample(bool v)		{ multisample = v; }
	
	void	SetMultiSamples(int samples)	{ num_multisamples = samples; }
	bool	IsMultiSample()					{ return multisample; }
	bool	NumMultiSamples()				{ return num_multisamples; }
	virtual int	GLChoosePixelFormat();
	
	void	StdView3D(float angle = 45.0f, float near = 1.0f, float far = 10000.0f);
	void	StdView3D(const Size &sz, float angle = 45.0f, float near = 1.0f, float far = 10000.0f);
	void	StdView2D();
	void 	Begin3D(float aspect, float angle = 45.0f, float near = 1.0f, float far = 1.0f);
	void	End3D();
	void 	Begin2D(const Rect &view, int near = 1, int far = -1);
	void	End2D()										{ End3D(); }
private:
	int 		frametime;
	float		clearcolor[4];
	bool		multisample;
	int			num_multisamples;
protected:	
};