struct PerlinNoise
{
public:
	PerlinNoise() : octaves(2), persistence(0.5f), frequency(1), power(1.0f) {}
	virtual ~PerlinNoise() {}

	PerlinNoise &Octaves(int _octaves) 		{ octaves = minmax(_octaves, 2, 31); return *this; }
	PerlinNoise &Persistence(float _pers) 	{ persistence = _pers; return *this; }
	PerlinNoise &Frequency(int freq) 		{ frequency = max(1, freq); return *this; }
	PerlinNoise &Power(float _power) 			{ power = minmax(_power, 0.05f, 99.0f); return *this; }

	float SmoothNoise1(int x, int y) const;
	float InterpolatedNoise1(float x, float y) const;
	float CosineInterpolate(float a, float b, float x) const;
	
	float PerlinNoise2D(int x, int y) const;
	float PerlinNoise2D(float x, float y) const;	
	float PerlinNoise3D(int x, int y, int z, int offset = 0x151) const
		{ return PerlinNoise2D(x + offset*z, y + offset*z); }
	float PerlinNoise3D(float x, float y, int z, int offset = 0x151) const
		{ return PerlinNoise2D(x + offset*z, y + offset*z); }		
		
	Buffer<float> 	CreateBuffer(int cx, int cy) const;
	Image			CreateImage(int cx, int cy) const;
	
protected:
	virtual float Noise(int x, int y) const;
	
	int octaves;
	float persistence;
	int frequency;
	float power;
};

class PerlinNoiseCache : public PerlinNoise
{
public:
	virtual ~PerlinNoiseCache() { cache.Clear(); }

	void Cache();
	virtual float Noise(int x, int y) const;
	void Clear() { cache.Clear(); }
	
private:
	enum { CACHE_SIZE = 256, CACHE_BITS = CACHE_SIZE-1 };
	Buffer<float> 			cache;
};