#include "UppGL.h"

Box & Box::Create(const Vec3f &a /*Min*/, const Vec3f &b /*Max*/)
{
	corner[0] = Vec3f(a.x, a.y, a.z);
	corner[1] = Vec3f(b.x, a.y, a.z);
	corner[2] = Vec3f(b.x, b.y, a.z);
	corner[3] = Vec3f(a.x, b.y, a.z);

	corner[4] = Vec3f(a.x, a.y, b.z);
	corner[5] = Vec3f(b.x, a.y, b.z);
	corner[6] = Vec3f(b.x, b.y, b.z);
	corner[7] = Vec3f(a.x, b.y, b.z);
	return *this;
}

void Box::GetMinMax(Vec3f &bounds_min, Vec3f &bounds_max) const
{
	bounds_min.x = bounds_min.y = bounds_min.z = 1000000.0f;
	bounds_max.x = bounds_max.y = bounds_max.z = -1000000.0f;
	for (int i = 0; i < 8; i++) {
		bounds_min.x = min(bounds_min.x, corner[i].x);
		bounds_min.y = min(bounds_min.y, corner[i].y);
		bounds_min.z = min(bounds_min.z, corner[i].z);
		bounds_max.x = max(bounds_max.x, corner[i].x);
		bounds_max.y = max(bounds_max.y, corner[i].y);
		bounds_max.z = max(bounds_max.z, corner[i].z);		
	}
}

void Box::GetMinMaxXY(Vec2f &bounds_min, Vec2f &bounds_max) const
{
	bounds_min.x = bounds_min.y = 1000000.0f;
	bounds_max.x = bounds_max.y = -1000000.0f;
	for (int i = 0; i < 8; i++) {
		bounds_min.x = min(bounds_min.x, corner[i].x);
		bounds_min.y = min(bounds_min.y, corner[i].y);
		bounds_max.x = max(bounds_max.x, corner[i].x);
		bounds_max.y = max(bounds_max.y, corner[i].y);
	}	
}

void Box::GetMinMaxZ(float &bounds_min, float &bounds_max) const
{
	bounds_min = 1000000.0f;
	bounds_max = -1000000.0f;
	for (int i = 0; i < 8; i++) {
		bounds_min = min(bounds_min, corner[i].z);
		bounds_max = max(bounds_max, corner[i].z);		
	}
}

Box & Box::operator*=(const Mat4f &m)
{
	for (int i = 0; i < 8; i++)
		corner[i] *= m;
	return *this;	
}

Box & Box::operator*=(float f)
{
	for (int i = 0; i < 8; i++)
		corner[i] *= f;	
	return *this;
}

Box & Box::operator+=(const Vec3f &p)
{
	for (int i = 0; i < 8; i++)
		corner[i] += p;		
	return *this;
}

Box & Box::operator-=(const Vec3f &p)
{
	for (int i = 0; i < 8; i++)
		corner[i] -= p;
	return *this;
}

Vec3f Box::Center() const
{
	Vec3f accum(0.0f, 0.0f, 0.0f);
	for (int i = 0; i < 8; i++)
		accum += corner[i];
	return accum / 8.0f;
}

void Box::Scale(float s)
{
	for (int i = 0; i < 8; i++)
		corner[i] *= s;
}

void Box::Translate(Vec3f pos)
{
	for (int i = 0; i < 8; i++)
		corner[i] += pos;	
}

void Box::RotateX(float rad)
{
	NEVER();
}

void Box::RotateY(float rad)
{
	NEVER();
}

void Box::RotateZ(float rad)
{
	NEVER();
}

void Box::RotateX(int p)
{
	NEVER();
}

void Box::RotateY(int p)
{
	NEVER();
}

void Box::RotateZ(int p)
{
	float tcos = QuickCos(p);
	float tsin = QuickSin(p);
	for (int i = 0; i < 8; i++) {
		QRotateZ(corner[i], tcos, tsin);
	}
}

float Box::SizeZ() const
{
	float minz = 1000000.0f;
	float maxz = -1000000.0f;
	for (int i = 0; i < 8; i++) {
		minz = min(minz, corner[i].z);
		maxz = max(maxz, corner[i].z);
	}
	return maxz - minz;		
}

float Box::MinZ() const
{
	float minz = 1000000.0f;
	for (int i = 0; i < 8; i++)
		minz = min(minz, corner[i].z);
	return minz;			
}

