#include "UppGL.h"

RenderChain::RenderChain()
{
	Clear();
}

void RenderChain::AddMaterialMesh(const GLMaterial &m, ChainSubMesh &c)
{
	int ix = render_chain_index.Find(m);
	if (ix < 0) {
		ChainHead &h = render_chain_index.Add(m);
		h.material = m;
		c.chain = &h;	
	}
	else
		c.chain = &render_chain_index[ix];
	init = false;
}

void RenderChain::Clear()
{
	render_chain_index.Clear();
	render_chain.Clear();
	sub_ptr = NULL;
	init = false;
}

void RenderChain::PreRenderInit()
{
	if (!init) {
		render_chain = render_chain_index.PickValues();
		render_chain.Shrink();
		render_chain_index.Clear();	
		// Initialise chain	
		Sort(render_chain);		
	}
	for (int i = 0; i < render_chain.GetCount(); i++) {
		ChainHead &h = render_chain[i];
		h.first = NULL;
		h.last = NULL;
	}		
	sub_ptr = NULL;
	init = true;
}

void RenderChain::AddRender0(RenderChain::ChainSubMesh &c)
{
	c.next = NULL;	
	if (c.chain->first)
		c.chain->last->next = &c;
	else
		c.chain->first = &c;
	c.chain->last = &c;
}

void RenderChain::AddToRenderChain(RenderChain::ChainSubMesh &c)
{
	AddRender0(c);	
}

void RenderChain::AddToRenderChain(Vector<RenderChain::ChainSubMesh> &v)
{
	ASSERT(init);
	ASSERT(v.GetCount());
	
	ChainSubMesh *ptr = &v[0];
	ChainSubMesh *end = &v.Top();
	++end;
	while (ptr < end) {
		AddToRenderChain(*ptr);
		++ptr;
	}
}

int RenderChain::GetFirstTranslucent() const
{
	for (int i = render_chain.GetCount()-1; i >= 0; --i)
		if (render_chain[i].material.IsTranslucent())
			return i+1;
	return 0;
}

GLMaterial & RenderChain::SetChain(int ix)
{
	sub_ptr = render_chain[ix].first;
	return render_chain[ix].material;
}

RenderChain::ChainSubMesh * RenderChain::FirstMesh()
{
	return sub_ptr;
}

RenderChain::ChainSubMesh * RenderChain::NextMesh()
{
	return (sub_ptr = sub_ptr->next);
}

void RenderChain::Render()
{
	for (int i = 0; i < GetCount(); i++) {
		SetChain(i).Activate();
		ChainSubMesh *m = FirstMesh();
		while (m) {
			glDrawElements(GL_TRIANGLES, m->count, GL_UNSIGNED_INT, (GLvoid *)m->byteoffset);	
			m = NextMesh();
		};
	}
}

void RenderChain::Dump()
{
#ifndef _DEBUG
	return;
#endif
	RLOG("RenderChain Dump");
	for (int i = 0; i < GetCount(); i++) {
		const GLMaterial &mat = SetChain(i);
		ChainSubMesh *m = FirstMesh();
		int cnt = 0;
		while (m) {
			m = NextMesh();
			cnt++;
		}

		RLOG(i << "- " << cnt << " Meshes - " << GetFileName(mat.GetUnit0().Name()) << "(" << mat.GetUnit0().Id() << "), 0x"
		       << FormatIntHex(mat.GetColor().Raw()) << ", " << (mat.IsTranslucent() ? "Trans." : "Opaque"));
	}
}

