class RenderChain 
{
	struct ChainHead;
public:
	struct ChainSubMesh : public Moveable<ChainSubMesh> {
		int			byteoffset;
		int			count;
	private:
		friend RenderChain;
		ChainHead  *chain;
		ChainSubMesh *next;
	};
private:
	ChainSubMesh *	sub_ptr;
	bool 			init;
	
	struct ChainHead {
		GLMaterial material;
		ChainSubMesh *first;
		ChainSubMesh *last;
		bool operator==(const ChainHead &h) const 	{ return material == h.material; }
		bool operator<(const ChainHead &h) const 	{ return material < h.material; }
	};
	ArrayMap<GLMaterial, ChainHead> render_chain_index;
	Array<ChainHead> render_chain;	
	
	void AddRender0(ChainSubMesh &c);
public:
	RenderChain();
	// Creation/Destruction
	void AddMaterialMesh(const GLMaterial &m, ChainSubMesh &c);
	void Clear();
	// Pre-Rendering
	void PreRenderInit();
	void AddToRenderChain(ChainSubMesh &c);
	void AddToRenderChain(Vector<RenderChain::ChainSubMesh> &v);

	// Rendering
	int GetCount() const			{ return render_chain.GetCount(); }
	int	GetFirstTranslucent() const;
	
	GLMaterial &SetChain(int ix);
	ChainSubMesh *FirstMesh();
	ChainSubMesh *NextMesh();
	
	void Dump();
	
	void Render();
};