///////////////////////////////////////////////////////////////////////////////////////////////////
// OpenGL Mathematics Copyright (c) 2005 - 2009 G-Truc Creation (www.g-truc.net)
///////////////////////////////////////////////////////////////////////////////////////////////////
// Created : 2005-12-21
// Updated : 2009-04-29
// Licence : This source is under MIT License
// File    : glm/gtx/transform.hpp
///////////////////////////////////////////////////////////////////////////////////////////////////
// Dependency:
// - GLM core
// - GLM_GTC_matric_transform
///////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef glm_gtx_transform
#define glm_gtx_transform

// Dependency:
#include "../glm.hpp"
#include "../gtc/matrix_transform.hpp"

namespace glm
{
	namespace test{
		void main_ext_gtx_transform();
	}//namespace test

	namespace gtx{
	//! GLM_GTX_transform extension: Add transformation matrices
	namespace transform
	{
		//! Builds a translation 4 * 4 matrix created from 3 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> translate(
			T x, T y, T z);
		
		//! Transforms a matrix with a translation 4 * 4 matrix created from 3 scalars. 
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> translate(
			const detail::tmat4x4<T> & m, 
			T x, T y, T z);
		
		//! Transforms a matrix with a translation 4 * 4 matrix created from a vector of 3 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> translate(
			const detail::tmat4x4<T> & m, 
			const detail::tvec3<T> & v);
		
		//! Builds a rotation 4 * 4 matrix created from an axis of 3 scalars and an angle expressed in degrees. 
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> rotate(
			T angle, 
			T x, T y, T z);

		//! Transforms a matrix with a rotation 4 * 4 matrix created from an axis of 3 scalars and an angle expressed in degrees. 
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> rotate(
			const detail::tmat4x4<T> & m, 
			T angle, 
			T x, T y, T z);
		
		//! Transforms a matrix with a rotation 4 * 4 matrix created from an axis vector and an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> rotate(
			const detail::tmat4x4<T> & m, 
			T angle, 
			const detail::tvec3<T> & v);
		
		//! Builds a scale 4 * 4 matrix created from 3 scalars. 
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> scale(
			T x, T y, T z);
		
		//! Transforms a matrix with a scale 4 * 4 matrix created from 3 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> scale(
			const detail::tmat4x4<T> & m, 
			T x, T y, T z);

		//! Transforms a matrix with a scale 4 * 4 matrix created from a vector of 3 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> scale(
			const detail::tmat4x4<T> & m, 
			const detail::tvec3<T> & v);
/*
		// 3D
		//! Transforms a matrix with a translation 4 * 4 matrix created from 3 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> translate3D(
			const detail::tmat4x4<T> & m, 
			T x, T y, T z);

		//! Transforms a matrix with a translation 4 * 4 matrix created from a vector of 3 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> translate3D(
			const detail::tmat4x4<T> & m, 
			const detail::tvec3<T> & v);

		//! Transforms a matrix with a rotation 4 * 4 matrix created from an axis of 3 scalars and an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> rotate3D(
			const detail::tmat4x4<T> & m, 
			T angle, 
			T x, T y, T z);
		
		//! Transforms a matrix with a rotation 4 * 4 matrix created from an axis vector and an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> rotate3D(
			const detail::tmat4x4<T> & m, 
			T angle, 
			const detail::tvec3<T> & v);
		
		//! Transforms a matrix with a rotation 3 * 3 matrix created from an axis of 3 scalars and an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> rotate3D(
			const detail::tmat3x3<T> & m, 
			T angle, 
			T x, T y, T z);
		
		//! Transforms a matrix with a rotation 3 * 3 matrix created from an axis vector and an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> rotate3D(
			const detail::tmat3x3<T> & m, 
			T angle, 
			const detail::tvec3<T> & v);
		
		//! Transforms a matrix with a scale 4 * 4 matrix created from 3 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> scale3D(
			const detail::tmat4x4<T> & m, 
			T x, T y, T z);
				
		//! Transforms a matrix with a scale 4 * 4 matrix created from a vector of 3 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat4x4<T> scale3D(
			const detail::tmat4x4<T> & m, 
			const detail::tvec3<T> & v);
		
		//! Transforms a matrix with a scale 3 * 3 matrix created from 3 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> scale3D(
			const detail::tmat3x3<T> & m, 
			T x, T y, T z);
				
		//! Transforms a matrix with a scale 3 * 3 matrix created from a vector of 3 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> scale3D(
			const detail::tmat3x3<T> & m, 
			const detail::tvec3<T> & v);

		// 2D
		
		//! Translates a 3 * 3 matrix from 2 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T>
		detail::tmat3x3<T> translate2D(
			const detail::tmat3x3<T> & m, 
			T x, T y);
		
		//! Translates a 3 * 3 matrix from a vector of 2 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> translate2D(
			const detail::tmat3x3<T> & m, 
			const detail::tvec2<T> & v);
		
		//! Rotates a 3 * 3 matrix from an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T>
		detail::tmat3x3<T> rotate2D(
			const detail::tmat3x3<T> & m, 
			T angle);
		
		//! Rotates a 2 * 2 matrix from an angle expressed in degrees.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat2x2<T> rotate2D(
			const detail::tmat2x2<T> & m, 
			T angle);
		
		//! Scales a 3 * 3 matrix using 2 scalars.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> scale2D(
			const detail::tmat3x3<T> & m, 
			T x, T y);
		
		//! Scales a 3 * 3 matrix using a vector of 2 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat3x3<T> scale2D(
			const detail::tmat3x3<T> & m, 
			const detail::tvec2<T> & v);
		
		//! Scales a 2 * 2 matrix using 2 scalars. 
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat2x2<T> scale2D(
			const detail::tmat2x2<T> & m, 
			T x, T y);

		//! Scales a 2 * 2 matrix using a vector of 2 components.
		//! From GLM_GTX_transform extension.
		template <typename T> 
		detail::tmat2x2<T> scale2D(
			const detail::tmat2x2<T> & m, 
			const detail::tvec2<T> & v);
*/
	}//namespace transform
	}//namespace gtx
}//namespace glm

#define GLM_GTX_transform namespace gtc::matrix_transform; using namespace gtx::transform
#ifndef GLM_GTX_GLOBAL
namespace glm {using GLM_GTX_transform;}
#endif//GLM_GTX_GLOBAL

#include "transform.inl"

#endif//glm_gtx_transform
