class Colorf : public Moveable<Colorf> {
	dword 		bcolor;
	GLfloat 	fcolor[4];
public:
	enum { NULL_COLORF = 0xDEADBEEF };

	Colorf() 														{ SetNull(); }
	Colorf(RGBA rgba) 												{ Set(rgba.r, rgba.g, rgba.b, rgba.a); }
	Colorf(byte r, byte g, byte b, byte a = 255)					{ Set(r, g, b, a); }
	Colorf(GLfloat r, GLfloat g, GLfloat b, GLfloat a = 1.0f) 		{ Set(r, g, b, a); }
	
	byte 	Rb() const		{ return (byte)(bcolor & 0x000000FF); } 
	byte 	Gb() const		{ return (byte)((bcolor & 0x0000FF00) >> 8); } 
	byte 	Bb() const		{ return (byte)((bcolor & 0x00FF0000) >> 16); } 
	byte 	Ab() const		{ return (byte)((bcolor & 0xFF000000) >> 24); } 
	GLfloat R() const		{ return fcolor[0]; }
	GLfloat G() const		{ return fcolor[1]; }
	GLfloat B() const		{ return fcolor[2]; }
	GLfloat A() const		{ return fcolor[3]; }

	void SetRed(float v)	{ fcolor[0] = v; ((byte*)&bcolor)[0] = (byte)(v*255); }
	void SetGreen(float v)	{ fcolor[1] = v; ((byte*)&bcolor)[1] = (byte)(v*255); }
	void SetBlue(float v)	{ fcolor[2] = v; ((byte*)&bcolor)[2] = (byte)(v*255); }
	void SetAlpha(float v)	{ fcolor[3] = v; ((byte*)&bcolor)[3] = (byte)(v*255); }

	void 	Set(byte r, byte g, byte b, byte a = 255) 
		{ Setb(r, g, b, a); Setf((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f); }
	void 	Set(GLfloat r, GLfloat g, GLfloat b, GLfloat a = 255) 
		{ Setf(r, g, b, a); Setb((byte)(r * 255.0f), (byte)(g * 255.0f), (byte)(b * 255.0f), (byte)(a * 255.0f)); }
	
	bool operator<(const Colorf &c) const		{ return bcolor < c.bcolor; }
	bool operator==(const Colorf &c) const		{ return bcolor == c.bcolor; }
	Colorf operator*(float v) const				{ return Colorf(R()*v, G()*v, B()*v, A()*v); }
	operator RGBA() const						{ RGBA out; out.r = Rb(); out.g = Gb(); out.b = Bb(); out.a = Ab(); return out; }
	
	void 	Activate() const					{ if (bcolor != NULL_COLORF) glColor4fv(fcolor); }
	void 	Activate(float alpha) const			{ if (bcolor != NULL_COLORF) glColor4f(fcolor[0], fcolor[1], fcolor[2], alpha); else glColor4f(1.0f, 0.0f, 1.0f, alpha); }
	const GLfloat *Get() const					{ return fcolor; }
	dword 	Raw()	const						{ return bcolor; }
	void 	SetRaw(dword raw)					{ Set((byte)(raw & 0x000000FF), (byte)((raw & 0x0000FF00) >> 8), (byte)((raw & 0x00FF0000) >> 16), (byte)((raw & 0xFF000000) >> 24)); }
	
	void 	SetNull()							{ bcolor = NULL_COLORF; Setf(0.0f, 0.0f, 0.0f, 1.0f); }
	bool	IsNullInstance() const				{ return bcolor == NULL_COLORF; }				
	
	void Serialize(Stream &s)					{ s % fcolor[0] % fcolor[1] % fcolor[2] % fcolor[3] % bcolor; }
	
	static const Colorf &Black()				{ static Colorf v((byte)0, (byte)0, (byte)0); return v; }
	static const Colorf &White()				{ static Colorf v((byte)255, (byte)255, (byte)255); return v; }
	static const Colorf &Gray()					{ static Colorf v((byte)128, (byte)128, (byte)128); return v; }	
private:
	void Setb(byte r, byte g, byte b, byte a) 				{ bcolor = (dword)r | ((dword)g << 8) | ((dword)b << 16) | ((dword)a << 24); }
	void Setf(GLfloat r, GLfloat g, GLfloat b, GLfloat a) 	{ fcolor[0] = r; fcolor[1] = g; fcolor[2] = b; fcolor[3] = a; }
};

void RawRGBA(RGBA &q, dword raw);
const Vector<dword> &GetDosColors();
int StrColorInt(String c);

struct ConvertHexColor : public Convert {
	virtual Value Scan(const Value& text) const {
		if (text.GetType() == STRING_V)
			return StrColorInt(text);
		return ErrorValue("Invalid Color");
	}
};