template <const GLenum T, bool defval> 
class GLEnableState
{
	int state;
protected:
	static int glstate;
	
public:
	GLEnableState() { state = defval; }

	void Activate() const 	{ if (glstate != state) { state ? glEnable(T) : glDisable(T); glstate = state; } }
	static void Disable()	{ glDisable(T); glstate = 0; }
	static void Enable()	{ glEnable(T); glstate = 1; }
	
	static bool IsEnabled() { return glstate; }
	
	void operator=(bool _state) 									{ state = _state; }
	void operator=(const GLEnableState<T, defval> &_state) 			{ state = _state.state; }
	bool operator==(const GLEnableState<T, defval> &_state) const 	{ return state == _state.state; }
	bool operator<(const GLEnableState<T, defval> &_state) const 	{ return state < _state.state; }
	bool operator>(const GLEnableState<T, defval> &_state) const 	{ return state > _state.state; }
	
	operator bool() const	{ return state; }
};

template <const GLenum T, bool defval> 
int GLEnableState<T, defval>::glstate = -1;

typedef GLEnableState<GL_CULL_FACE, true> GLCullState;
typedef GLEnableState<GL_LIGHTING, true> GLLightingState;
typedef GLEnableState<GL_LIGHT0, true> GLLight0;
typedef GLEnableState<GL_DEPTH_TEST, true> GLDepthState;
typedef GLEnableState<GL_BLEND, false> GLBlendState;

class GLAlphaTestState
{
	int state;
protected:
	static int glstate;
	
	void Activate0(int state) const { if (glstate != state) { state ? glEnable(GL_ALPHA_TEST) : glDisable(GL_ALPHA_TEST); glstate = state; } } 
public:
	GLAlphaTestState() 		{ state = false; }

	void Activate() const 	{ Activate0(state && !GLBlendState::IsEnabled()); }
	static void Disable()	{ glDisable(GL_ALPHA_TEST); glstate = 0; }
	static void Enable()	{ glEnable(GL_ALPHA_TEST); glstate = 1; }
	
	static bool IsEnabled() { return glstate; }
	
	void operator=(bool _state) 							{ state = _state; }
	void operator=(const GLAlphaTestState &_state) 			{ state = _state.state; }
	bool operator==(const GLAlphaTestState &_state) const 	{ return state == _state.state; }
	bool operator<(const GLAlphaTestState &_state) const 	{ return state < _state.state; }
	bool operator>(const GLAlphaTestState &_state) const 	{ return state > _state.state; }
	
	operator bool() const	{ return state; }
};

struct GLScopedEnable {
	GLenum type;
	GLScopedEnable(GLenum _type) : type(_type) 	{ glEnable(type); }
	~GLScopedEnable() 							{ glDisable(type); }
};

struct GLScopedDisable {
	GLenum 	type;
	GLScopedDisable(GLenum _type) : type(_type) 	{ glDisable(type); }
	~GLScopedDisable() 								{ glEnable(type); }
};

#define SCOPE_ENABLE(x) GLScopedEnable _enable_##x##(x)
#define SCOPE_DISABLE(x) GLScopedDisable _disable_##x##(x)