#include "UppGL.h"

#ifdef far
#undef far
#undef near
#endif

#include "WGL_ARB_multisample.h"

int GLViewCtrl::GLChoosePixelFormat()
{
	if (!multisample || num_multisamples == 0) return 0;
    int pf = 0;
    if (num_multisamples > 0) { // attempt to pick specific sample rate if specified
        ChooseAntiAliasingPixelFormat(pf, num_multisamples);
     	if (!pf)
     		GLLog(Format("Anti-aliasing not available with %d samples. Choosing best.", num_multisamples));
    }
	if (!pf) // Choose best
    	ChooseBestAntiAliasingPixelFormat(pf);
	if (pf)
		GLLog(Format("Anti-aliasing: %s", GetAntiAliasingPixelFormatString()));
	else
		GLLog("No anti-aliasing available");
	multisample = pf;
	return pf;
}

void GLViewCtrl::EnableVerticalSync(bool enable)
{
	if (GLEE_WGL_EXT_swap_control) {
        wglSwapIntervalEXT(enable ? 1 : 0);
        GLLog(Format("Vertical sync %s", enable ? "enabled" : "disabled"));
	}
	else
		GLLog("Vertical sync not supported");
}

void GLViewCtrl::SetClearColor(float r, float g, float b, float a)
{
	clearcolor[0] = r;
	clearcolor[1] = g;
	clearcolor[2] = b;
	clearcolor[3] = a;
}

void GLViewCtrl::ClearColor()
{
	glClearColor(clearcolor[0], clearcolor[1], clearcolor[2], clearcolor[3]);
}

Image GLViewCtrl::CursorImage(Point p, dword keyflags)
{
	return HasCapture() ? Image() : Image::Arrow();
}

void GLViewCtrl::GLResize(int w, int h)
{
	if (HasCamera()) {
		StdView3D(Size(w, h), GetCamera().GetFOV(), GetCamera().GetNearPlane(), GetCamera().GetFarPlane());
		if (HasFrustum())
			GetFrustum().SetProjection(GetCamera().GetFOV()+GetFrustumFOVDelta(), (GLfloat)(w)/(GLfloat)(h), GetCamera().GetNearPlane(), GetCamera().GetFarPlane());
	}
	else {
		StdView3D(Size(w, h), 45.0f, 1.0f, 1000.0f);
	}
}

void GLViewCtrl::LeftDrag(Point p, dword keyflags)
{
	if (HasCamera()) {
		StartDC();
		GetCamera().OnDragStart(p);
		SetCapture();
	}
}

void GLViewCtrl::LeftUp(Point p, dword keyflags)
{
	ReleaseCapture();
}

void GLViewCtrl::MouseMove(Point p, dword keyflags)
{
	if (HasCamera() && HasCapture()) {
		StartDC();
		if (GetCamera().OnMouseDrag(p, keyflags))	
			WhenGLCameraMove();
	}
	else if (HasCamera())
		GetCamera().OnDragStart(p);
}

void GLViewCtrl::MouseWheel(Point p, int zdelta, dword keyflags)
{
	if (HasCamera()) {
		StartDC();
		if (GetCamera().OnMouseWheel(p, zdelta, keyflags))	
			WhenGLCameraMove();
	}
}

bool GLViewCtrl::Key(dword key, int count)
{
	if (HasCamera()) {
		StartDC();
		if (GetCamera().Key(key, count)) {
			WhenGLCameraMove();	
			return true;
		}
	}
	return false;
}

void GLViewCtrl::StdView3D(const Size &sz, float angle, float near, float far)
{
	glViewport(0, 0, (GLsizei)sz.cx, (GLsizei)sz.cy);	
	Begin3D((GLfloat)(sz.cx)/(GLfloat)(sz.cy), angle, near, far);	
}

void GLViewCtrl::StdView3D(float angle, float near, float far)
{
	StdView3D(GetSize(), angle, near, far);
}

void GLViewCtrl::StdView2D()
{
	Size sz = GetSize();
	glViewport(0, 0, (GLsizei)sz.cx, (GLsizei)sz.cy);	
	Begin2D(sz);
}

void GLViewCtrl::Begin3D(float aspect, float angle, float near, float far)
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();	
	gluPerspective(angle, aspect, near, far);
	
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	
	glShadeModel(GL_SMOOTH);
	glClearDepth(1.0f);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	
	glEnable(GL_DEPTH_TEST);
}

void GLViewCtrl::Begin2D(const Rect &view, int near, int far)
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(view.left, view.right, view.top, view.bottom, -near, far);
   
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(0.375, 0.375, 0.);

	glDisable(GL_DEPTH_TEST);
}

void GLViewCtrl::End3D()
{
   glMatrixMode(GL_PROJECTION);
   glPopMatrix();   
   glMatrixMode(GL_MODELVIEW);
   glPopMatrix();	
}

GLViewCtrl::GLViewCtrl()
{
	frametime = 0;
	multisample = false;
	num_multisamples = -1;
	WhenGLCameraMove = THISBACK(GLRefresh);
	
	SetClearColor(0.0f, 0.0f, 0.0f, 0.5f);	
}
