#include "UppGL.h"


Buffer<float> PerlinNoise::CreateBuffer(int cx, int cy) const
{
	ASSERT(cx >= 1 && cy >= 1);
	Buffer<float> cache(cx*cy);
	float *q = ~cache;
	for (int y = 0; y < cy; y++)
		for (int x = 0; x < cx; x++) {
			*q = PerlinNoise2D(x, y);
			++q;
		}
	return cache;
}

Image PerlinNoise::CreateImage(int cx, int cy) const
{
	ASSERT(cx >= 1 && cy >= 1);
	ImageBuffer ib(cx, cy);
	RGBA *q = ~ib;
	for (int y = 0; y < cy; y++)
		for (int x = 0; x < cx; x++) {
			float p = PerlinNoise2D(x, y);
			q->r = int(255 * p);
			q->g = q->b = q->r;
			q->a = 255;	
			++q;
		}
	return ib;
}

void PerlinNoiseCache::Cache() { 
	cache.Alloc(CACHE_SIZE*CACHE_SIZE, 0.0f);
	float *q = ~cache;
	for (int j = 0; j < CACHE_SIZE; j++)
		for (int i = 0; i < CACHE_SIZE; i++) {
			*q = (float)(rand() & RAND_MAX) / ((float)(RAND_MAX)); 
			++q;
		}
}
float PerlinNoiseCache::Noise(int x, int y) const 
{ 
	return cache[(x & CACHE_BITS) + (y & CACHE_BITS)*CACHE_SIZE]; 
}

/*
** Original author: Hugo Elias
** http://freespace.virgin.net/hugo.elias/models/m_perlin.htm
** Modified and corrected by James Thomas
*/
float PerlinNoise::Noise(int x, int y) const
{
	int n = x + y * 22283;
	n = (n<<13) ^ n;
	return ( 1.0f - ( (n * (n * n * 15731 + 789221) + 1376312589) & 0x7fffffff) / 1073741824.0f);    
}

float PerlinNoise::SmoothNoise1(int x, int y) const 
{
	float corners = ( Noise(x-1, y-1)+Noise(x+1, y-1)+Noise(x-1, y+1)+Noise(x+1, y+1) ) / 16;
	float sides   = ( Noise(x-1, y)  +Noise(x+1, y)  +Noise(x, y-1)  +Noise(x, y+1) ) /  8;
	float center  =  Noise(x, y) / 4;
	return corners + sides + center;
}

float PerlinNoise::CosineInterpolate(float a, float b, float x) const
{
	float ft = x * 3.1415927f;
	float f = (1 - (float)cos(ft)) * 0.5f;
	return  a*(1-f) + b*f;
}

float PerlinNoise::InterpolatedNoise1(float x, float y) const
{
	int integer_X   	 	= int(x);
	float fractional_X 		= x - integer_X;

	int integer_Y    		= int(y);
	float fractional_Y 		= y - integer_Y;

	float v1 = SmoothNoise1(integer_X,     integer_Y);
	float v2 = SmoothNoise1(integer_X + 1, integer_Y);
	float v3 = SmoothNoise1(integer_X,     integer_Y + 1);
	float v4 = SmoothNoise1(integer_X + 1, integer_Y + 1);

	float i1 = CosineInterpolate(v1, v2, fractional_X);
	float i2 = CosineInterpolate(v3, v4, fractional_X);

	return CosineInterpolate(i1, i2, fractional_Y);
}

float PerlinNoise::PerlinNoise2D(int x, int y) const
{
	float total = 0;
	float amplitude = 1.0f;
	float max = 0.0f;
	int freq = frequency;
	float fx = float(x);
	float fy = float(y);
	for (int i = 0; i < octaves; i++) {
		total = total + InterpolatedNoise1(fx / freq, fy / freq) * amplitude;
		max += amplitude;
		amplitude *= persistence;
		freq <<= 1;
	}
	return powf(total / max, power);
}

float PerlinNoise::PerlinNoise2D(float x, float y) const
{
	float total = 0;
	float amplitude = 1.0f;
	float max = 0.0f;
	int freq = frequency;
	float fx = float(x);
	float fy = float(y);
	for (int i = 0; i < octaves; i++) {
		total = total + InterpolatedNoise1(fx / freq, fy / freq) * amplitude;
		max += amplitude;
		amplitude *= persistence;
		freq <<= 1;
	}
	return powf(total / max, power);
}
/*
** End of Hugo Elias code
*/