#define VERTEX_TANGENT_ATTRIB 16

struct Triangle32 : public Moveable<Triangle32>
{
public:
	Triangle32() {} 
	Triangle32(int _a, int _b, int _c) : a(_a), b(_b), c(_c) {}
public:
	int a, b, c;
};

struct Triangle16 : public Moveable<Triangle16>
{
public:
	Triangle16() {} 
	Triangle16(short _a, short _b, short _c) : a(_a), b(_b), c(_c) {}
public:
	short a, b, c;
};

struct Quad32 : public Moveable<Quad32>
{
public:
	Quad32() {} 
	Quad32(int _a, int _b, int _c, int _d) : a(_a), b(_b), c(_c), d(_d) {}

	Triangle32 Triangle1() const { return Triangle32(a, b, c); }
	Triangle32 Triangle2() const { return Triangle32(c, d, a); }
public:
	int a, b, c, d;
};

struct Quad16 : public Moveable<Quad16>
{
public:
	Quad16() {} 
	Quad16(short _a, short _b, short _c, short _d) : a(_a), b(_b), c(_c), d(_d) {}

	Triangle16 Triangle1() const { return Triangle16(a, b, c); }
	Triangle16 Triangle2() const { return Triangle16(c, d, a); }
public:
	short a, b, c, d;
};

struct Vertex3P3N2T : public Moveable<Vertex3P3N2T>
{
	Vec3f position;
	Vec3f normal;
	Vec2f texture0;
	// Aligned for 32-bytes - no padding	
};

struct Box : public Moveable<Box>
{
	Vec3f corner[8];
	
	Box &Create(const Vec3f &bounds_min, const Vec3f &bounds_max);
	void GetMinMax(Vec3f &bounds_min, Vec3f &bounds_max) const;
	void GetMinMaxXY(Vec2f &bounds_min, Vec2f &bounds_max) const;
	void GetMinMaxZ(float &bounds_min, float &bounds_max) const;

	Box &operator*=(const Mat4f &m);
	Box &operator*=(float f);
	Box &operator+=(const Vec3f &p);
	Box &operator-=(const Vec3f &p);

	Box operator*(const Mat4f &m) const	{ return Box(*this) *= m; }
	Box operator*(float f) const			{ return Box(*this) *= f; }
	Box operator+(const Vec3f &p) const	{ return Box(*this) += p; }
	Box operator-(const Vec3f &p) const	{ return Box(*this) -= p; }
	
	Vec3f &operator[](int i)				{ return corner[i]; }
	const Vec3f &operator[](int i) const	{ return corner[i]; }
	
	Vec3f	Center() const;
	
	void Scale(float s);
	void Translate(Vec3f pos);

	void RotateX(float rad);
	void RotateY(float rad);
	void RotateZ(float rad);

	void RotateX(int p);
	void RotateY(int p);
	void RotateZ(int p);
	
	float MinZ() const;
	float MaxZ() const { return 0.0f; }
	float SizeZ() const;	
	
	void Serialize(Stream &s)			{ for (int i = 0; i < 8; i++) s % corner[i]; }
};