#include "UppGL.h"

#ifdef _DEBUG
bool gl_debug = true;
#else
bool gl_debug = false;
#endif
void SetDebugMode() { gl_debug = true; }
bool IsDebug()		{ return gl_debug; }

bool ShaderSupport() { return GLEE_ARB_shading_language_100 && GLEE_ARB_shader_objects && 
    	GLEE_ARB_vertex_shader && GLEE_ARB_fragment_shader; }
bool FBOSupport() { return GLEE_EXT_framebuffer_object; }


// Camera
Camera *	camera = NULL;
Camera& 	GetCamera()						{ ASSERT(camera); return *camera; }
void 		SetCamera(Camera &_camera)		{ camera = &_camera; }
bool		HasCamera()						{ return camera; }
void		NoCamera()						{ camera = NULL; }
// Frustum
Frustum *	frustum = NULL;
float		fovdelta = 0.0f;
Frustum& 	GetFrustum()					{ ASSERT(frustum); return *frustum; }
void 		SetFrustum(Frustum &_frustum) 	{ frustum = &_frustum; }
bool		HasFrustum()					{ return frustum; }
float 		GetFrustumFOVDelta()			{ return fovdelta; }
void		SetFrustumFOVDelta(float fov)	{ fovdelta = fov; }

// Lights
GLLight *	light0 = NULL;
GLLight&	GetLight0()						{ ASSERT(light0); return *light0; }
void		SetLight0(GLLight &light)		{ light0 = &light; }
// Shaders
bool use_shaders = ShaderSupport();
bool UseShaders() 			{ return use_shaders; }
void EnableShaders(bool v) 	{ use_shaders = v && ShaderSupport(); GLLog(use_shaders ? "Shaders enabled" : "Shaders disabled"); }
// Bump mapping
bool use_bump_mapping = ShaderSupport();
bool UseBumpMapping()				{ return use_bump_mapping; }
void EnableBumpMapping(bool v) 		{ use_bump_mapping = ShaderSupport() && v; GLLog(use_bump_mapping ? "Bump mapping enabled" : "Bump mapping disabled"); }


// Errors
String 		lastglerror;
String 		LastGLError()					{ String e = lastglerror; lastglerror.Clear(); return e; }
void		GLClearError()					{ lastglerror.Clear(); }
void 		GLError(String s) 				{ lastglerror = s; RLOG(s); }
bool 		GLErrorF(String s)		 		{ GLError(s); return false; }
String 		GLErrorS(String s) 				{ GLError(s); return String(); }
int 		GLErrorI(String s, int v)		{ GLError(s); return v; }
bool 		IsGLError()						{ return lastglerror.GetLength(); }
void 		GLLog(const String &s)			{ RLOG(s); }

// Paths
Vector<String> standard_path;
void		SetLocalPath(int id, const String &path) 	{ SetFullPath(id, LocalFile(path)); }
void		SetFullPath(int id,  const String &path)	{ standard_path.At(id, LocalDir()) = path; }
String 		GetFullPath(int id,  const String &path)			
{ 
	if (IsFullPath(path)) return path;
	return (id < 0 || id >= standard_path.GetCount()) ? 
		LocalFile(path) : AppendFileName(standard_path[id], path); 
}

Vec3f GetNormal(const Vec3f &a, const Vec3f &b, const Vec3f &c)
{
	return glm::cross((b - a), (c - a));
}

Vec3f GetNormal(const Triangle32 &t, Vector<Vec3f> &v)
{
	return GetNormal(v[t.a], v[t.b], v[t.c]);
}

Vec3f GetNormal(const Triangle16 &t, Vector<Vec3f> &v)
{
	return GetNormal(v[(int)t.a], v[(int)t.b], v[(int)t.c]);
}

bool IsKey(KeyInfo &info, dword key) 
{
	return key == info.key[0] || key == info.key[1];
}

void DestroyVBO(GLuint vboid) { glDeleteBuffersARB(1, &vboid); }

void BasicMode(bool depthtest)
{
	glPushAttrib(GL_ENABLE_BIT);
	if (!depthtest)
		glDisable(GL_DEPTH_TEST);
	
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	ShaderProgram::Deactivate();	
}

void EndBasicMode()
{
	glPopAttrib();
}

void RenderAxis(float size, bool depthtest)
{
	BasicMode(depthtest);
	glBegin(GL_LINES);
		glColor3f(1.0f, 0.0f, 0.0f);
		glVertex3f(0.0f, 0.0f, 0.0f);
		glVertex3f(size, 0.0f, 0.0f);

		glColor3f(0.0f, 1.0f, 0.0f);
		glVertex3f(0.0f, 0.0f, 0.0f);
		glVertex3f(0.0f, size, 0.0f);

		glColor3f(0.0f, 0.0f, 1.0f);
		glVertex3f(0.0f, 0.0f, 0.0f);
		glVertex3f(0.0f, 0.0f, size);
	glEnd();
	EndBasicMode();	
}

void RenderBox(const Box &box, bool depthtest)
{
	BasicMode(depthtest);
	glBegin(GL_LINES);
	for (int i = 0; i < 3; i++) {
		glVertex3fv(&box.corner[i].x);
		glVertex3fv(&box.corner[i+1].x);
	}
	glVertex3fv(&box.corner[3].x);
	glVertex3fv(&box.corner[0].x);
	
	for (int i = 4; i < 7; i++) {
		glVertex3fv(&box.corner[i].x);
		glVertex3fv(&box.corner[i+1].x);
	}
	glVertex3fv(&box.corner[7].x);
	glVertex3fv(&box.corner[4].x);
	
	for (int i = 0; i < 4; i++) {
		glVertex3fv(&box.corner[i].x);
		glVertex3fv(&box.corner[i+4].x);
	}
	
	glEnd();
	EndBasicMode();	
}

void RenderZPlane(float sz)
{
	BasicMode(true);

	sz /= 2.0f;

	glBegin(GL_QUADS);
	glVertex3f(-sz, -sz, 0.0f);
	glVertex3f(sz, -sz, 0.0f);
	glVertex3f(sz, sz, 0.0f);
	glVertex3f(-sz, sz, 0.0f);

	EndBasicMode();	
}


// Declared in Colorf.h
void RawRGBA(RGBA &q, dword raw) {
	q.r = (byte)(raw & 0x000000FF);
	q.g = (byte)((raw & 0x0000FF00) >> 8);
	q.b = (byte)((raw & 0x00FF0000) >> 16);
	q.a = (byte)((raw & 0xFF000000) >> 24);
}

const Vector<dword> &GetDosColors()
{
	static Vector<dword> colors;
	if (!colors.GetCount()) {
		colors.Add(0xFF000000); //  0 Black			
		colors.Add(0xFF800000); //  1 Blue
		colors.Add(0xFF378200); //  2 Green
		colors.Add(0xFF808000); //  3 Cyan
		colors.Add(0xFF000080); //  4 Red
		colors.Add(0xFF800080); //  5 Magenta
		colors.Add(0xFF2970A1); //  6 Brown
		colors.Add(0xFF969696); //  7 Lgray
		colors.Add(0xFF505050); //  8 Dgray
		colors.Add(0xFFFF6432); //  9 Lblue
		colors.Add(0xFF32C832); // 10 Lgreen
		colors.Add(0xFFF0B43C); // 11 Lcyan
		colors.Add(0xFF0000FF); // 12 Lred
		colors.Add(0xFFF500FF); // 13 Lmagenta
		colors.Add(0xFF00DCFF); // 14 Yellow
		colors.Add(0xFFFFFFFF); // 15 White	
	}
	return colors;	
}

int StrColorInt(String c)
{
	if (c.GetLength() > 2 && c[0] == '0' && c[1] == 'x') {
		if (c.GetLength() == 10)
			return (c == "0xFFFFFFFF") ? 0xFFFFFFFF : ScanInt(c.Begin() + 2, NULL, 16);
		if (c.GetLength() == 8)
			return 0xFF000000 | ScanInt(c.Begin() + 2, NULL, 16);
		GLError("Invalid hexidecimal color"); 
		return INT_NULL;
	}
	else {
		int color_index = StrInt(c);
		if (!IsNull(color_index) && color_index >= 0 && color_index <= 15)
			return GetDosColors()[color_index];
		GLError("Invalid color index");
		return INT_NULL;
	}				
}

int GLAlphaTestState::glstate = false;

#ifdef _DEBUG
String localroot;
void SetLocalFileRoot(const char *root) { localroot = root; }
String LocalDir()						{ return localroot; }
String LocalFile(String file) 			{ return AppendFileName(localroot, file); }
#define MULTIMAT_STAT
#define DRAW_AXIS
#else
void SetLocalFileRoot(const char *root) { }
String LocalDir()						{ return GetFileFolder(GetExeFilePath()); }
String LocalFile(String file) 			{ return GetExeDirFile(file); }
#endif