///////////////////////////////////////////////////////////////////////////////////////////////////
// OpenGL Mathematics Copyright (c) 2005 - 2009 G-Truc Creation (www.g-truc.net)
///////////////////////////////////////////////////////////////////////////////////////////////////
// Created : 2009-04-29
// Updated : 2009-04-29
// Licence : This source is under MIT License
// File    : glm/gtc/matrix_operation.inl
///////////////////////////////////////////////////////////////////////////////////////////////////

namespace glm{
namespace gtc{
namespace matrix_operation
{
	template <typename valType> 
	inline detail::tmat2x2<valType> inverse
	(
		detail::tmat2x2<valType> const & m
	)
	{
		//valType Determinant = m[0][0] * m[1][1] - m[1][0] * m[0][1];
		valType Determinant = determinant(m);

		detail::tmat2x2<valType> Inverse(
			+ m[1][1] / Determinant,
			- m[1][0] / Determinant,
			- m[0][1] / Determinant, 
			+ m[0][0] / Determinant);

		return Inverse;
	}

	template <typename valType> 
	inline detail::tmat3x3<valType> inverse
	(
		detail::tmat3x3<valType> const & m
	)
	{
		//valType Determinant = m[0][0] * (m[1][1] * m[2][2] - m[2][1] * m[1][2])
		//					- m[1][0] * (m[0][1] * m[2][2] - m[2][1] * m[0][2])
		//					+ m[2][0] * (m[0][1] * m[1][2] - m[1][1] * m[0][2]);

		valType Determinant = determinant(m);

		detail::tmat3x3<valType> Inverse;
		Inverse[0][0] = + (m[1][1] * m[2][2] - m[2][1] * m[1][2]);
		Inverse[1][0] = - (m[1][0] * m[2][2] - m[2][0] * m[1][2]);
		Inverse[2][0] = + (m[1][0] * m[2][1] - m[2][0] * m[1][1]);
		Inverse[0][1] = - (m[0][1] * m[2][2] - m[2][1] * m[0][2]);
		Inverse[1][1] = + (m[0][0] * m[2][2] - m[2][0] * m[0][2]);
		Inverse[2][1] = - (m[0][0] * m[2][1] - m[2][0] * m[0][1]);
		Inverse[0][2] = + (m[0][1] * m[1][2] - m[1][1] * m[0][2]);
		Inverse[1][2] = - (m[0][0] * m[1][2] - m[1][0] * m[0][2]);
		Inverse[2][2] = + (m[0][0] * m[1][1] - m[1][0] * m[0][1]);
		Inverse /= Determinant;

		return Inverse;
	}

	template <typename valType> 
	inline detail::tmat4x4<valType> inverse
	(
		detail::tmat4x4<valType> const & m
	)
	{
		valType SubFactor00 = m[2][2] * m[3][3] - m[3][2] * m[2][3];
		valType SubFactor01 = m[2][1] * m[3][3] - m[3][1] * m[2][3];
		valType SubFactor02 = m[2][1] * m[3][2] - m[3][1] * m[2][2];
		valType SubFactor03 = m[2][0] * m[3][3] - m[3][0] * m[2][3];
		valType SubFactor04 = m[2][0] * m[3][2] - m[3][0] * m[2][2];
		valType SubFactor05 = m[2][0] * m[3][1] - m[3][0] * m[2][1];
		valType SubFactor06 = m[1][2] * m[3][3] - m[3][2] * m[1][3];
		valType SubFactor07 = m[1][1] * m[3][3] - m[3][1] * m[1][3];
		valType SubFactor08 = m[1][1] * m[3][2] - m[3][1] * m[1][2];
		valType SubFactor09 = m[1][0] * m[3][3] - m[3][0] * m[1][3];
		valType SubFactor10 = m[1][0] * m[3][2] - m[3][0] * m[1][2];
		valType SubFactor11 = m[1][1] * m[3][3] - m[3][1] * m[1][3];
		valType SubFactor12 = m[1][0] * m[3][1] - m[3][0] * m[1][1];
		valType SubFactor13 = m[1][2] * m[2][3] - m[2][2] * m[1][3];
		valType SubFactor14 = m[1][1] * m[2][3] - m[2][1] * m[1][3];
		valType SubFactor15 = m[1][1] * m[2][2] - m[2][1] * m[1][2];
		valType SubFactor16 = m[1][0] * m[2][3] - m[2][0] * m[1][3];
		valType SubFactor17 = m[1][0] * m[2][2] - m[2][0] * m[1][2];
		valType SubFactor18 = m[1][0] * m[2][1] - m[2][0] * m[1][1];

		detail::tmat4x4<valType> Inverse(
			+ (m[1][1] * SubFactor00 - m[1][2] * SubFactor01 + m[1][3] * SubFactor02),
			- (m[0][1] * SubFactor00 - m[0][2] * SubFactor01 + m[0][3] * SubFactor02),
			+ (m[0][1] * SubFactor06 - m[0][2] * SubFactor07 + m[0][3] * SubFactor08),
			- (m[0][1] * SubFactor13 - m[0][2] * SubFactor14 + m[0][3] * SubFactor15),

			- (m[1][0] * SubFactor00 - m[1][2] * SubFactor03 + m[1][3] * SubFactor04),
			+ (m[0][0] * SubFactor00 - m[0][2] * SubFactor03 + m[0][3] * SubFactor04),
			- (m[0][0] * SubFactor06 - m[0][2] * SubFactor09 + m[0][3] * SubFactor10),
			+ (m[0][0] * SubFactor13 - m[0][2] * SubFactor16 + m[0][3] * SubFactor17),

			+ (m[1][0] * SubFactor01 - m[1][1] * SubFactor03 + m[1][3] * SubFactor05),
			- (m[0][0] * SubFactor01 - m[0][1] * SubFactor03 + m[0][3] * SubFactor05),
			+ (m[0][0] * SubFactor11 - m[0][1] * SubFactor09 + m[0][3] * SubFactor12),
			- (m[0][0] * SubFactor14 - m[0][1] * SubFactor16 + m[0][3] * SubFactor18),

			- (m[1][0] * SubFactor02 - m[1][1] * SubFactor04 + m[1][2] * SubFactor05),
			+ (m[0][0] * SubFactor02 - m[0][1] * SubFactor04 + m[0][2] * SubFactor05),
			- (m[0][0] * SubFactor08 - m[0][1] * SubFactor10 + m[0][2] * SubFactor12),
			+ (m[0][0] * SubFactor15 - m[0][1] * SubFactor17 + m[0][2] * SubFactor18));

		//valType Determinant = determinant(m);
		valType Determinant = m[0][0] * Inverse[0][0] 
							+ m[0][1] * Inverse[1][0] 
							+ m[0][2] * Inverse[2][0] 
							+ m[0][3] * Inverse[3][0];

		Inverse /= Determinant;
	    
		return Inverse;
	}

	template <typename valType>
	inline typename detail::tmat2x2<valType>::value_type determinant
	(
		detail::tmat2x2<valType> const & m
	)
	{
		return m[0][0] * m[1][1] - m[1][0] * m[0][1];
	}

	template <typename valType>
	inline typename detail::tmat3x3<valType>::value_type determinant
	(
		detail::tmat3x3<valType> const & m
	)
	{
		return m[0][0] * (m[1][1] * m[2][2] - m[2][1] * m[1][2])
			- m[1][0] * (m[0][1] * m[2][2] - m[2][1] * m[0][2])
			+ m[2][0] * (m[0][1] * m[1][2] - m[1][1] * m[0][2]);
	}

	template <typename valType>
	inline typename detail::tmat4x4<valType>::value_type determinant
	(
		detail::tmat4x4<valType> const & m
	)
	{
		valType SubFactor00 = m[2][2] * m[3][3] - m[3][2] * m[2][3];
		valType SubFactor01 = m[2][1] * m[3][3] - m[3][1] * m[2][3];
		valType SubFactor02 = m[2][1] * m[3][2] - m[3][1] * m[2][2];
		valType SubFactor03 = m[2][0] * m[3][3] - m[3][0] * m[2][3];
		valType SubFactor04 = m[2][0] * m[3][2] - m[3][0] * m[2][2];
		valType SubFactor05 = m[2][0] * m[3][1] - m[3][0] * m[2][1];

		detail::tvec4<valType> DetCof(
			+ (m[1][1] * SubFactor00 - m[1][2] * SubFactor01 + m[1][3] * SubFactor02),
			- (m[1][0] * SubFactor00 - m[1][2] * SubFactor03 + m[1][3] * SubFactor04),
			+ (m[1][0] * SubFactor01 - m[1][1] * SubFactor03 + m[1][3] * SubFactor05),
			- (m[1][0] * SubFactor02 - m[1][1] * SubFactor04 + m[1][2] * SubFactor05));

		return m[0][0] * DetCof[0]
			 + m[0][1] * DetCof[1]
			 + m[0][2] * DetCof[2]
			 + m[0][3] * DetCof[3];
	}

}//namespace matrix_operation
}//namespace gtc
}//namespace glm
