#include <Core/Core.h>


//*************************************************************************************************************************************************************
//									AUTOMATION de EXCEL
//*************************************************************************************************************************************************************

#define _WIN32_WINNT 0x0501
#define _WIN32_IE 0x0501
#include <windows.h>
#include <ole2.h>
#include <stdio.h>

#include <libExcel/libExcel.h>

#define DISP_FREEARGS 0x01
#define DISP_NOSHOWEXCEPTIONS 0x02

VARIANT xlApp = {0};//excel.exe
VARIANT xlBooks = {0}; // collection de carnet
VARIANT xlBook = {0}; // 1 carnet
VARIANT xlSheet = {0}; //1 feuille
VARIANT strVariant = {0};
VARIANT lgVariant = {0};
VARIANT cellValue = {0};//valeur
VARIANT cellRange = {0};//selection
VARIANT arr = {0} ; //tableau
VARIANT xlFont = {0}; // police

//COleVariant  covOptional((long)DISP_E_PARAMNOTFOUND, VT_ERROR);

//*****************************************************************************************
//*								Fonctions Speciale
//*****************************************************************************************
/**
 * @brief Automation helper function
 */
HRESULT AutoWrap(int autoType, VARIANT *pvResult, IDispatch *pDisp, LPOLESTR ptName, int cArgs...)
{
    // Begin variable-argument list...
    va_list marker;
    va_start(marker, cArgs);

    if(!pDisp)
        {
        MessageBox(NULL, "NULL IDispatch passed to AutoWrap()", "Error", 0x10010);
        _exit(0);
    }

    // Variables used...
    DISPPARAMS dp = { NULL, NULL, 0, 0 };
    DISPID dispidNamed = DISPID_PROPERTYPUT;
    DISPID dispID;
    HRESULT hr;
    char buf[200];
    char szName[200];

    // Convert down to ANSI
    WideCharToMultiByte(CP_ACP, 0, ptName, -1, szName, 256, NULL, NULL);

    // Get DISPID for name passed...
    hr = pDisp->GetIDsOfNames(IID_NULL, &ptName, 1, LOCALE_USER_DEFAULT, &dispID);
    if(FAILED(hr))
        {
        sprintf(buf, "IDispatch::GetIDsOfNames(\"%s\") failed w/err 0x%08lx", szName, hr);
        MessageBox(NULL, buf, "AutoWrap()", 0x10010);
        //_exit(0);
        return hr;
    }

    // Allocate memory for arguments...
    VARIANT *pArgs = new VARIANT[cArgs+1];
    // Extract arguments...
    for(int i=0; i<cArgs; i++)
        {
        pArgs[i] = va_arg(marker, VARIANT);
    }

    // Build DISPPARAMS
    dp.cArgs = cArgs;
    dp.rgvarg = pArgs;

    // Handle special-case for property-puts!
    if(autoType & DISPATCH_PROPERTYPUT)
        {
        dp.cNamedArgs = 1;
        dp.rgdispidNamedArgs = &dispidNamed;
    }

    // Make the call!
    hr = pDisp->Invoke(dispID, IID_NULL, LOCALE_SYSTEM_DEFAULT, autoType, &dp, pvResult, NULL, NULL);
    if(FAILED(hr))
        {
                sprintf(buf, "IDispatch::Invoke(\"%s\"=%08lx) failed w/err 0x%08lx",
                        szName, dispID, hr);
                MessageBox(NULL, buf, "AutoWrap()", 0x10010);
                switch(hr)
                {
                case DISP_E_BADPARAMCOUNT:
                        MessageBox(NULL, "DISP_E_BADPARAMCOUNT", "Error:", 0x10010);
                        break;
                case DISP_E_BADVARTYPE:
                        MessageBox(NULL, "DISP_E_BADVARTYPE", "Error:", 0x10010);
                        break;
                case DISP_E_EXCEPTION:
                        MessageBox(NULL, "DISP_E_EXCEPTION", "Error:", 0x10010);
                        break;
                case DISP_E_MEMBERNOTFOUND:
                        MessageBox(NULL, "DISP_E_MEMBERNOTFOUND", "Error:", 0x10010);
                        break;
                case DISP_E_NONAMEDARGS:
                        MessageBox(NULL, "DISP_E_NONAMEDARGS", "Error:", 0x10010);
                        break;
                case DISP_E_OVERFLOW:
                        MessageBox(NULL, "DISP_E_OVERFLOW", "Error:", 0x10010);
                        break;
                case DISP_E_PARAMNOTFOUND:
                        MessageBox(NULL, "DISP_E_PARAMNOTFOUND", "Error:", 0x10010);
                        break;
                case DISP_E_TYPEMISMATCH:
                        MessageBox(NULL, "DISP_E_TYPEMISMATCH", "Error:", 0x10010);
                        break;
                case DISP_E_UNKNOWNINTERFACE:
                        MessageBox(NULL, "DISP_E_UNKNOWNINTERFACE", "Error:", 0x10010);
                        break;
                case DISP_E_UNKNOWNLCID:
                        MessageBox(NULL, "DISP_E_UNKNOWNLCID", "Error:", 0x10010);
                        break;
                case DISP_E_PARAMNOTOPTIONAL:
                        MessageBox(NULL, "DISP_E_PARAMNOTOPTIONAL", "Error:", 0x10010);
                        break;
                }
                // _exit(0);
                return hr;
        }
    // End variable-argument section...
    va_end(marker);

    delete [] pArgs;

    return hr;
}

//conversion BSTR to CHAR
void BSTRtoASC (BSTR str, char * &strRet) {
	if ( str != NULL ) {
		unsigned long length = WideCharToMultiByte (CP_ACP,0, str,SysStringLen(str), NULL, 0,NULL, NULL	);
		//strRet = new char[length];
		length = WideCharToMultiByte (CP_ACP,0, str,SysStringLen(str), reinterpret_cast <char *>(strRet), length,NULL, NULL	);
		strRet[length] = '\0';
	}
}

//translating row and column number into the string name of the cell.
void IndToStr(int row,int col,char* strResult) {
	if(col>26) {
          sprintf(strResult,"%c%c%d\0",'A'+(col-1)/26-1,'A'+(col-1)%26,row);
    }
	else {
		sprintf(strResult,"%c%d\0",'A'+(col-1)%26,row);
    }
}

//**********************************************************************************
//										La classe
//**********************************************************************************

MyExcel::MyExcel() {
	// Initialize COM for this thread...
	CoInitialize(NULL);

}

MyExcel::~MyExcel() {
	//relesase
	Release();

   // Uninitialize COM for this thread...
   CoUninitialize();
}

void MyExcel::Release(void) {

VariantClear(&xlApp);
VariantClear(&xlBooks);
VariantClear(&xlBook);
VariantClear(&xlSheet);
VariantClear(&cellValue);
VariantClear(&lgVariant);
VariantClear(&cellRange);
VariantClear(&arr);
VariantClear(&xlFont);

}

bool MyExcel::NewExcel(void)
{
  CLSID clsExcelApp;

  // if Excel is already running, return with current instance
  if (xlApp.pdispVal != NULL)
    return true;

  /* Obtain the CLSID that identifies EXCEL.APPLICATION
   * This value is universally unique to Excel versions 5 and up, and
   * is used by OLE to identify which server to start.  We are obtaining
   * the CLSID from the ProgID.
   */
   if(FAILED(CLSIDFromProgID(L"Excel.Application", &clsExcelApp))) {
      MessageBox(NULL, "CLSIDFromProgID() failed", "Error", 0x10010);
      return false;
   }

  // start a new copy of Excel, grab the IDispatch interface
  if (FAILED(CoCreateInstance(clsExcelApp, NULL, CLSCTX_LOCAL_SERVER, IID_IDispatch, (void **)&xlApp.pdispVal)))
  {
	MessageBox(NULL, "Excel not registered properly", "Error", 0x10010);
	return false;
  }

	// recupere la liste des carnets
	AutoWrap(DISPATCH_PROPERTYGET|DISPATCH_METHOD, &xlBooks, xlApp.pdispVal, L"Workbooks", 0);

   return true;
}

bool MyExcel::RecupExcel(void)
{
  CLSID clsExcelApp;

  // if Excel is already running, return with current instance
  if (xlApp.pdispVal != NULL)
    return true;

  /* Obtain the CLSID that identifies EXCEL.APPLICATION
   * This value is universally unique to Excel versions 5 and up, and
   * is used by OLE to identify which server to start.  We are obtaining
   * the CLSID from the ProgID.
   */
   if(FAILED(CLSIDFromProgID(L"Excel.Application", &clsExcelApp))) {
      MessageBox(NULL, "CLSIDFromProgID() failed", "Error", 0x10010);
      return false;
   }

   IUnknown *pUnk;
   HWND hExcelMainWnd = 0;
   hExcelMainWnd = FindWindow("XLMAIN",NULL);
   if(hExcelMainWnd) {
	   SendMessage(hExcelMainWnd,WM_USER + 18, 0, 0);
		HRESULT hr2 = GetActiveObject(clsExcelApp,NULL,(IUnknown**)&pUnk);
		if (!FAILED(hr2)) {
			hr2=pUnk->QueryInterface(IID_IDispatch, (void **)&xlApp.pdispVal);
			if (!xlApp.ppdispVal) {
				MessageBox(NULL, "Failed to find instance!!", "Error",MB_ICONHAND);
				return false;
			}
		}
		//Release the no-longer-needed IUnknown...
		if (pUnk) pUnk->Release();
	}
	else {
		MessageBox(NULL, "Failed to find instance!!", "Error",MB_ICONHAND);
		return false;
	}

	// recupere la liste des carnets
	AutoWrap(DISPATCH_PROPERTYGET|DISPATCH_METHOD, &xlBooks, xlApp.pdispVal, L"Workbooks", 0);

	return true;
}


bool MyExcel::Quit(void) {
  AutoWrap(DISPATCH_METHOD, NULL, xlApp.pdispVal, L"Quit", 0);
  return true;
}

bool MyExcel::Close(void) {
  AutoWrap(DISPATCH_METHOD, NULL, xlSheet.pdispVal, L"Close", 0);
  return true;
}

bool MyExcel::Save(void) {
	AutoWrap(DISPATCH_METHOD, NULL, xlApp.pdispVal, L"Save", 0);
	return true;
}

bool MyExcel::SaveAs(char *file) {

    if( file == NULL) {
        MessageBox(NULL, "Nom du fichier manquant", "Error", 0x10010);
        return false;
    }

	WCHAR str[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0,file, -1, str, MAX_PATH);

    VARIANT vaPath;
    vaPath.vt = VT_BSTR;
    vaPath.bstrVal = SysAllocString(str);

//	VARIANT fformat;
//	fformat.vt = VT_I4;
//	fformat.lVal=-4143;

    AutoWrap(DISPATCH_METHOD, NULL, xlBook.pdispVal, L"SaveAs", 1, vaPath);

    SysFreeString(vaPath.bstrVal);
	VariantClear(&vaPath);

	SetSave(true);

	return true;
}


bool MyExcel::Open(char *file) {

    if( file == NULL) {
        MessageBox(NULL, "file name is null", "Error", 0x10010);
        return false;
    }

	WCHAR str[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0,file, -1, str, MAX_PATH);

    VARIANT vaPath;
    vaPath.vt = VT_BSTR;
    vaPath.bstrVal = SysAllocString(str);

    AutoWrap(DISPATCH_METHOD, &xlBook, xlBooks.pdispVal, L"Open", 1, vaPath);

    SysFreeString(vaPath.bstrVal);
	VariantClear(&vaPath);

	return true;
}


bool MyExcel::IsExcelRunning()
{
	if (xlApp.pdispVal == NULL) return false;
	if (!FindWindow("XLMAIN",NULL))return false;
	return true;
}


bool MyExcel::SetVisible(bool fVisible)
{
	VariantClear(&lgVariant);
	lgVariant.vt = VT_I4;
	lgVariant.lVal = fVisible;
	HRESULT hr = AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlApp.pdispVal, L"Visible", 1, lgVariant);

	return true;
}

bool MyExcel::ShowGrid(bool b)
{

	IDispatch *pXlWindows;
	IDispatch *pXlWindow;

	VariantInit(&strVariant);
	AutoWrap(DISPATCH_PROPERTYGET, &strVariant, xlApp.pdispVal, L"Windows", 0);
	pXlWindows = strVariant.pdispVal;

	VARIANT xwind;
	xwind.vt=VT_I4;
	xwind.lVal=1;
	VariantInit(&strVariant);
	AutoWrap(DISPATCH_PROPERTYGET, &strVariant, pXlWindows, L"Item", 1,xwind);
	pXlWindow = strVariant.pdispVal;

	VARIANT xprop;
	xprop.vt=VT_BOOL;
	xprop.boolVal=b;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlWindow, L"DisplayGridlines", 1,xprop);

	pXlWindows->Release();
	pXlWindow->Release();

	VariantClear(&xprop);
	VariantClear(&xwind);

	return true;

}

bool MyExcel::SetPic(char* file, double dtop, double dleft, double dwidth, double dheight) {

	if (file == NULL) return false;

	WCHAR str[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0,file, -1, str, MAX_PATH);

	IDispatch *pXlShapes;

	VariantInit(&strVariant);

	AutoWrap(DISPATCH_PROPERTYGET, &strVariant, xlSheet.pdispVal, L"Shapes", 0);
	pXlShapes = strVariant.pdispVal;

	VARIANT fname;
	fname.vt = VT_BSTR;
	fname.bstrVal=SysAllocString(str);
	VARIANT xpropf;
	xpropf.vt=VT_BOOL;
	xpropf.boolVal=FALSE;
	VARIANT xpropt;
	xpropt.vt=VT_BOOL;
	xpropt.boolVal=TRUE;

	VARIANT xtop;
	xtop.vt=VT_R8;
//	xtop.dblVal=10.0;
	xtop.dblVal= dtop;
	VARIANT xleft;
	xleft.vt=VT_R8;
//	xleft.dblVal=10.0;
	xleft.dblVal= dleft;
	VARIANT xwidth;
	xwidth.vt=VT_R8;
//	xwidth.dblVal=200.0;
	xwidth.dblVal= dwidth;
	VARIANT xheight;
	xheight.vt=VT_R8;
//	xheight.dblVal= 200.0;
	xheight.dblVal= dheight;

	//Les arguments doivent etre pass a l'envers
	AutoWrap(DISPATCH_METHOD, NULL, pXlShapes, L"AddPicture", 7,xheight,xwidth,xleft,xtop,xpropt,xpropf,fname);

	SysFreeString(fname.bstrVal);

	pXlShapes->Release();

	VariantClear(&xheight);
	VariantClear(&xwidth);
	VariantClear(&xleft);
	VariantClear(&xtop);
	VariantClear(&xpropt);
	VariantClear(&xpropf);
	VariantClear(&fname);

	return true;
}

bool MyExcel::GetWorkbook(int book) {
	VariantClear(&lgVariant);
	lgVariant.vt = VT_I4;
	lgVariant.lVal = book;

	//AutoWrap(DISPATCH_PROPERTYGET|DISPATCH_METHOD, &xlBook, xlBooks.pdispVal, L"Workbooks", 1, lgVariant);
	//AutoWrap(DISPATCH_PROPERTYGET|DISPATCH_METHOD, &xlBook, xlApp.pdispVal, L"Workbooks", 0);
	//AutoWrap(DISPATCH_PROPERTYGET, &xlBook, xlApp.pdispVal, L"Activebooks", 0);

	xlBook.pdispVal = xlApp.pdispVal;

	return true;
}

bool MyExcel::AddWorkbook(void) {
    AutoWrap(DISPATCH_PROPERTYGET|DISPATCH_METHOD, &xlBook, xlBooks.pdispVal, L"Add", 0);
	return true;
}

bool MyExcel::SetWoksheetName(char *name) {
	WCHAR str[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0,name, -1, str, MAX_PATH);

	VARIANT parm;
	VariantClear(&parm);
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlSheet.pdispVal, L"Name", 1, parm);

	SysFreeString(parm.bstrVal);
	VariantClear(&parm);

	return true;
}


bool MyExcel::GetWorksheet(int sheet) {

	VariantClear(&lgVariant);
	lgVariant.vt = VT_I4;
	lgVariant.lVal = sheet;

	AutoWrap(DISPATCH_PROPERTYGET|DISPATCH_METHOD, &xlSheet, xlBook.pdispVal, L"Worksheets", 1, lgVariant);

	return true;
}
bool MyExcel::AddWorksheet(void) {

	VariantClear(&lgVariant);
	lgVariant.vt = VT_I4;
	lgVariant.lVal = 1;

	AutoWrap(DISPATCH_PROPERTYGET, &xlSheet, xlApp.pdispVal, L"Worksheets", 1, lgVariant);

    AutoWrap(DISPATCH_PROPERTYGET, &xlBook, xlSheet.pdispVal, L"Add", 0);

	return true;
}


bool MyExcel::SetSave(bool b) {
	// Set .Saved property of workbook to 'Saved'
	VariantClear(&lgVariant);
	lgVariant.vt = VT_I4;
	lgVariant.lVal = b;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlBook.pdispVal, L"Saved", 1, lgVariant);

	return true;
}

//*************************************************************************

bool MyExcel::Protect(char* pass) {
	WCHAR str[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0,pass, -1, str, MAX_PATH);

	VARIANT strVariant;
	VariantClear(&strVariant);
	strVariant.vt = VT_BSTR;
	strVariant.bstrVal = SysAllocString(str);
	AutoWrap(DISPATCH_METHOD, NULL, xlSheet.pdispVal, L"protect", 1, strVariant);

	SysFreeString(strVariant.bstrVal);
	VariantClear(&strVariant);

	return true;
}
bool MyExcel::UnProtect(char* pass) {
	WCHAR str[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0,pass, -1, str, MAX_PATH);

	VARIANT strVariant;
	VariantClear(&strVariant);
	strVariant.vt = VT_BSTR;
	strVariant.bstrVal = SysAllocString(str);
	AutoWrap(DISPATCH_METHOD, NULL, xlSheet.pdispVal, L"Unprotect", 1, strVariant);

	SysFreeString(strVariant.bstrVal);
	VariantClear(&strVariant);

	return true;
}

bool MyExcel::ResizeCell(char* pPos) {

	return false;

}


//************************************************************************
bool MyExcel::RunFormula(char* cellule,char* pPos)
{
	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,cellule, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	VariantClear(&cellRange);
	AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);

	SysFreeString(parm.bstrVal);
	VariantClear(&parm);

	if( pPos == NULL ) return false;

	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	AutoWrap(DISPATCH_PROPERTYPUT, NULL, cellRange.pdispVal, L"Formula", 1, parm);

	SysFreeString(parm.bstrVal);
	VariantClear(&parm);

	return true;
	return false;
}

bool MyExcel::AutoFit(char* pPos)
{
	if( pPos == NULL ) return false;

	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	VariantClear(&cellRange);
	AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);

    IDispatch *pXlRange2;
    pXlRange2 = cellRange.pdispVal;
    IDispatch *pXlCols1;
    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, pXlRange2, L"EntireColumn", 0);
    AutoWrap(DISPATCH_METHOD, NULL, cellRange.pdispVal, L"AutoFit", 0);
}

bool MyExcel::FormatCell(char* pPos, char *format)
{
	if( pPos == NULL ) return false;

	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	VariantClear(&cellRange);
	AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);

	MultiByteToWideChar(CP_ACP, 0,format, -1, str, 100);

	//on selectionne
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, cellRange.pdispVal, L"NumberFormat", 1, parm);
}

bool MyExcel::SelectRange(char* pPos) {
	if( pPos == NULL ) return false;

	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	VariantClear(&cellRange);

	AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);

	SysFreeString(parm.bstrVal);
	VariantClear(&parm);

	return true;
}

bool MyExcel::SetColor(long c1,long c2) {

	IDispatch *pXlInside;
	//on selectionne l'interieur de la cellule
	VARIANT color;

	VariantInit(&strVariant);
	AutoWrap(DISPATCH_PROPERTYGET, &strVariant, cellRange.pdispVal, L"Interior", 0);
	pXlInside = strVariant.pdispVal;
	//on applique la couleur
	color.vt = VT_I4;
	color.lVal=c1;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlInside, L"Color",1,color);

	//on selectionne le texte
	AutoWrap(DISPATCH_PROPERTYGET, &xlFont, cellRange.pdispVal, L"Font", 0);
	//on chnage la couleur
	color.vt = VT_I4;
	color.lVal=c2;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlFont.pdispVal, L"Color",1,color);

	VariantClear(&color);
	pXlInside->Release();

	return true;

}

bool MyExcel::SetRowHeight(char *pPos, char *height)
{
	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);
    IDispatch *pXlReSizedRange1;
    pXlReSizedRange1 = cellRange.pdispVal;

    // Appliquer hauteur
	WCHAR str2[255];
	MultiByteToWideChar(CP_ACP, 0, height, -1, str2, 255);

	VariantClear(&cellValue);
	cellValue.vt = VT_BSTR;
	cellValue.bstrVal=SysAllocString(str2);

    AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlReSizedRange1, L"RowHeight", 1, cellValue);

    return true;
}

bool MyExcel::SetColumnWidth(char *pPos, char *height)
{
	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);
    IDispatch *pXlReSizedRange1;
    pXlReSizedRange1 = cellRange.pdispVal;

    // Appliquer largeur
    WCHAR str2[100];
    MultiByteToWideChar(CP_ACP, 0, height, -1, str2, 255);

	VariantClear(&cellValue);
	cellValue.vt = VT_BSTR;
	cellValue.bstrVal=SysAllocString(str2);

    AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlReSizedRange1, L"ColumnWidth", 1, cellValue);

    return true;
}

bool MyExcel::SetBorder(char *pPos, char *width, long c1)
{
	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	//on selectionne
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

	WCHAR str2[255];
//	MultiByteToWideChar(CP_ACP, 0, "4", -1, str2, 255);
	MultiByteToWideChar(CP_ACP, 0, width, -1, str2, 255);

	VariantClear(&cellValue);
	cellValue.vt = VT_BSTR;
	cellValue.bstrVal=SysAllocString(str2);

//    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, COleVariant("E1:E6"));
    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);
//  AutoWrap(DISPATCH_PROPERTYGET, &result, pXlRange2, L"Resize", 2, COleVariant((short)3), covOptional); //NOTE parameters in reverse order
    IDispatch *pXlReSizedRange1;
    pXlReSizedRange1 = cellRange.pdispVal;

    IDispatch *pXlBorders;
    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, pXlReSizedRange1, L"Borders", 0);
    pXlBorders = cellRange.pdispVal;
//    AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlBorders, L"Weight", 1, COleVariant((short)2)); //xlThin = 2
    AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlBorders, L"Weight", 1, cellValue); //xlThin = 2

// Pour la couleur de lla bordure
    IDispatch *pXlInside;
    VARIANT color;
    color.vt = VT_I4;
	color.lVal=c1;
    AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlBorders, L"Color",1,color);
}

bool MyExcel::SetAlignment(char *pPos, char* hztl, char* vrtcl)
{
	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,pPos, -1, str, 100);

	// Horizontal
	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = SysAllocString(str);

    AutoWrap(DISPATCH_PROPERTYGET, &cellRange, xlSheet.pdispVal, L"Range", 1, parm);
    AutoWrap(DISPATCH_PROPERTYPUT, NULL, cellRange.pdispVal, L"HorizontalAlignment", 1, parm);
}

bool MyExcel::SetFont(char *font, bool bold, bool under,int size) {

	if (&cellRange == NULL) return false;

	//convertion char to str
	WCHAR str[100];
	MultiByteToWideChar(CP_ACP, 0,font, -1, str, 100);

	//on selectionne le texte
	AutoWrap(DISPATCH_PROPERTYGET, &xlFont, cellRange.pdispVal, L"Font", 0);

	VARIANT xprop;

	//gras
	xprop.vt=VT_BOOL;
	xprop.boolVal=bold;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlFont.pdispVal, L"Bold", 1,xprop);

	//underline
	xprop.vt=VT_I4;
	xprop.lVal=1;
	if (under) xprop.lVal=2;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlFont.pdispVal, L"Underline", 1,xprop);

	//police
	if (font != NULL) {
		VariantInit(&xprop);
		xprop.vt = VT_BSTR;
		xprop.bstrVal = SysAllocString(str);
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlFont.pdispVal, L"Name", 1,xprop);
		SysFreeString(xprop.bstrVal);
	}

	//taille
	if (size > 0 ) {
		VariantInit(&xprop);
		xprop.vt = VT_I4;
		xprop.lVal=size;
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, xlFont.pdispVal, L"Size",1,xprop);
	}

	VariantClear(&xprop);

	return true;

}


//*********************************************************************************************

bool MyExcel::GetData(char* pPos, char* pData)
{
	if (pData == NULL) return false;

	//on selectionne une zone ou cellule
	if (!SelectRange(pPos)) return false;

	//on lit la selection
	VariantClear(&cellValue);
	cellValue.vt=VT_BSTR;
	AutoWrap(DISPATCH_PROPERTYGET, &cellValue, cellRange.pdispVal, L"Value", 0, 0);

	if (cellValue.vt==VT_EMPTY)
	{
		pData[0]='\0';
	}
	else
	{
		VariantChangeType(&cellValue, &cellValue, VARIANT_NOUSEROVERRIDE, VT_BSTR);

		//int length = WideCharToMultiByte (CP_ACP,0, tmp.bstrVal,SysStringLen(tmp.bstrVal), pData, sizeof(pData)-1,NULL, NULL);
		//pData[length] = '\0';
		BSTRtoASC(cellValue.bstrVal,pData);
	}
	// Release references...
	VariantClear(&cellValue);
	VariantClear(&cellRange);

	return true;
}


bool MyExcel::SetData(char* pPos, char* pData)
{

	if(pData == NULL) return false;

	//on selctionne une zone ou cellule
	if (!SelectRange(pPos)) return false;


	// On ecrit nos valeurs dans la selection
	WCHAR str2[255];
	MultiByteToWideChar(CP_ACP, 0,pData, -1, str2 , 255);

	VariantClear(&cellValue);
	cellValue.vt=VT_BSTR;
	cellValue.bstrVal=SysAllocString(str2);

	AutoWrap(DISPATCH_PROPERTYPUT, NULL, cellRange.pdispVal, L"Value", 1, cellValue);

	// Release references...
	VariantClear(&cellValue);
	//VariantClear(&cellRange);

	return true;
}


//******************************************************************************************

bool MyExcel::CopyDataRange(char* pPos1, char* pPos2)
{
	if ( pPos2 == NULL ) return false;

	//initialisation du tableau qui va receuillir les donnes
	VariantClear(&arr);
	arr.vt=VT_BSTR;
	//arr.vt = VT_ARRAY | VT_VARIANT;

	//on selectionne la zone ou on va copier
	if (!SelectRange(pPos1)) return false;
	//on copie
	AutoWrap(DISPATCH_PROPERTYGET, &arr, cellRange.pdispVal, L"Value", 0, 0);

	//on selectionne la zone ou on va coller
	if (!SelectRange(pPos2)) return false;
	//On colle
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, cellRange.pdispVal, L"Value", 1, arr);

	// Release references...
	VariantClear(&cellRange);

	return true;
}


//***********************************************************************
