#include "dnd.h"

void Tile::LeftDrag(Point p,dword keyflags){
	LOG("LeftDrag()");
	if(!HasCapture()) {
		LOG("Dragging");
		ImageDraw iw(GetSize());
		iw.DrawRect(GetSize(),color);
		iw.DrawText(10,10,text);
		if(DoDragAndDrop("Tile",iw) == DND_MOVE) {
			LOG("Dropped");
			SetColor(White()).SetText("");
			Refresh();
		}
	}
}

void Tile::DragAndDrop(Point p, PasteClip& d){
	LOG("DragAndDrop()");
	if(IsDragAndDropSource()){
		d.SetAction(DND_COPY); //to prevent clearing itself
	}
	if(d.Accept("Tile")){
		LOG("DnD Accepted");
		Tile* src=(Tile*)GetDragAndDropSource();
		SetText(src->text).SetColor(src->color);
		Refresh();
	}
}

void Tile::Paint(Draw& w){
	Rect r=GetSize();
	if(istarget){
		w.DrawRect(r,Black());
		r.Deflate(2);
	}
	w.DrawRect(r,color);
	w.DrawText(10,10,text);
}


dnd::dnd()
{
	CtrlLayout(*this, "Window title");
	a1.SetText("a1").SetColor(LtBlue());
	a2.SetText("a2").SetColor(LtRed());
	b1.SetText("b1").SetColor(LtGreen());
	b2.SetText("b2").SetColor(Yellow());
}

GUI_APP_MAIN
{
	dnd().Run();
}

