#include <CtrlLib/CtrlLib.h>
using namespace Upp;

class SlideSw : public Ctrl {
	
	typedef enum { HORZ, VERT } HOVE;
	
public:
	typedef enum { TOP, BOTTOM, 
		RIGHT = TOP, LEFT = BOTTOM} LABEL_ALIGNMENT;
	
	typedef enum {CONTROL, INDICATOR} SLIDESWTYPES;
	

private:
	// Names of the positions
	Vector<String>	m_vValues;

	// convert from slider value to window coords
	int				SliderToClient(int value) const;
	// convert slider coords to slider value
	int				ClientToSlider(int x) const;

	// return const int if Horizontal or Vertical
	int				HoVe(int  x, int  y) const;
	
	// return a pointer to const int if horizontal or vertical
	int&			HoVeR(int& x, int& y) const;

	LABEL_ALIGNMENT	m_TickPosition;			// top/bottom for HSlidesw 
											// or left/right for Vslidesw
	Color			mFillColor;				// what color to use for filling the slider
	SLIDESWTYPES	mSlideSwType;			// either a CONTROL / INDICATOR
	int				m_Pos;

// The slider is divided into the following zones
// Full = the width for a vertical slider / height for a horiz slider
// Half  = half size
// Quart = quarter the size
// Eighth= eighth of the size
	int	Full, Half, Quart, Eighth;

protected:

	void			DrawTick( Draw &w, HOVE Orientation, int nPos );

public:
	typedef SlideSw CLASSNAME;

	Callback		WhenSlideFinish;
	
					SlideSw();
	virtual 		~SlideSw();

	virtual void	Paint(Draw& draw);
	virtual bool	Key(dword key, int repcnt);
	virtual void	LeftDown(Point pos, dword keyflags);
	virtual void	LeftRepeat(Point pos, dword keyflags);
	virtual void	LeftUp(Point pos, dword keyflags);
	virtual void	MouseMove(Point pos, dword keyflags);
	virtual void	GotFocus();
	virtual void	LostFocus();


	bool			IsVert() const;
	void			Inc()		{ if (m_Pos < m_vValues.GetCount()) m_Pos++; Refresh(); };
	void			Dec()		{ if (m_Pos)	m_Pos--; Refresh(); };

	// set the names for the positions
	SlideSw&		SetData(const int Pos, const String Name)	
					{ 
						if (!IsNull(m_vValues[Pos]))	m_vValues.Remove(Pos);
						m_vValues.At(Pos,Name); 
					};
					
	// set the slidesw position
	void			SetPos( int Pos=0 )					{ m_Pos = Pos; Refresh(); };	
	// return the current switch position
	int				GetPos() const						{ return m_Pos;  };

	SlideSw&		SetTickPosition( LABEL_ALIGNMENT n ){ m_TickPosition = n; return *this; };
	SlideSw&		FillColor( Color c )				{ mFillColor = c; return *this; };
	SlideSw&		SlideSwType( SLIDESWTYPES s)		{ mSlideSwType = s; return *this;};
};
