#include "Snow3G.h"

CONSOLE_APP_MAIN
{
	//initialization
	uint32 key[4] = {0x12345678,0x90ABCDEF,0x12345678,0x90ABCDEF};
	uint32 iv[4] = {0,0,0,0};
	Initialize(key,iv);
	
	//input data
	String input="Hello world! abcdefghijklmnopqrs...";
	int len=input.GetCount();
	DUMP(input);DUMP(len);

	//output buffer
	StringBuffer output(input);
	uint32* out32=(uint32*)~output;
	
	//generate keystream
	int n=len/4; // This is actually wrong, because if len is not multiple of 4 
	DUMP(n);     // then last (len%4) bytes will be unencryped. Feel free to fix it ;-)
	uint32 keystream[n];
	GenerateKeystream(n,keystream);
	
	//encode
	for(int i=0;i<n;i++){
		out32[i]^=keystream[i];
	}
	
	//show encrypted string
	String result=output;
	DUMP(result); DUMP(result.GetLength());
	
	//decode
	output.Cat(result);
	out32=(uint32*)~output;
	for(int i=0;i<n;i++){
		out32[i]^=keystream[i];
	}
	
	//show decrypted string
	result=output;
	DUMP(result); DUMP(result.GetLength());
}

