#include <CtrlLib/CtrlLib.h>
#include <Scatter/Scatter.h>
#include <Report/Report.h>
#include <Functions4U/Functions4U.h>

using namespace Upp;

#define LAYOUTFILE <ScatterBug_TestCase/ScatterBug_TestCase.lay>
#include <CtrlCore/lay.h>

#define TOPICFILE <ScatterBug_TestCase/app.tpp/all.i>
#include <Core/topic_group.h>


class TestCase : public WithTestCaseLayout<TopWindow> {
public:
	typedef TestCase CLASSNAME;
	TestCase()
	{
		CtrlLayout(*this, "Window title");
		bGo << THISBACK(PrintReport);
		Sizeable();
		PrintReport();
	}
	
	void PrintReport()
	{
		Scatter  graph2;
		Vector<XY> points;
		points << XY(5,5) << XY(15,5) << XY(5,15) << XY(25,35);
		graph2.H_Border(55).V_Border(55).SetTitle(t_("Rapport POIDS / TAILLE")).SetLabelX(t_("Weight")).SetLabelY(t_("Length"));
		graph2.SetRect(0,0,600,350);
		graph2.AddSeries(points, "poids/taille", true);
		graph2.SetRange(30, 50).SetXYMin(0,0);
		graph2.SetMarkStyle(0, Scatter::CIRCLE);
		graph2.SetMarkWidth(0, 25);
		graph2.SetMarkColor(0, Blue);
		graph2.SetDataThickness(0, 10);
		
		Report r;
		String rep;
		{
		const String graphString = AsQTF( CreateDrawingObject(graph2.GetDrawing()) );
		rep = Upp::GetTopic( "topic://ScatterBug_TestCase/app/testTopic$en-us" ).text;
		rep = Replace(rep, "#GRAPH1", graphString);
		}
		r << rep;
		Perform(r);
	}
};

// ===================================================
// ===================================================
GUI_APP_MAIN
{
	TestCase().Run();
}

