#ifndef _OPath_URightCtrl_h_
#define _OPath_URightCtrl_h_
#define IMAGECLASS OPathImg
#define IMAGEFILE <OPath/OPath.iml>
#include <Draw/iml.h>
#include "Database/Database.h"



class URightCtrl : public WithURightCtrl<TopWindow> {
    WithURightViewN1<ParentCtrl> viewN1;
    WithURightViewN2<ParentCtrl> viewN2;
    WithURightViewS1<ParentCtrl> viewS1;
    WithURightViewS2<ParentCtrl>  viewS2;
public:
    
    void Action();
//    void Action1();
	typedef URightCtrl CLASSNAME;
    void    ShowNE();
    void    ShowCH();
    bool    ShowPorts(String id);
    void    Close();

	URightCtrl();

private:
   void    ClearPorts();
   struct Rec:Moveable<Rec>
   {
       int     item;
       String  Id;
       public:
       Rec(int i,String s){item=i;Id=s;}
       ~Rec(){}
   };
   int FindItembyKey(Vector<Rec> &v,String key);
};

URightCtrl::URightCtrl()
{
	//SetFrame(/*RightSeparatorFrame()*/ViewFrame());
	SetFrame(LeftSeparatorFrame()/*XPFieldFrame()*/);
	CtrlLayout(*this, "");
	CtrlLayout(viewN1);
	CtrlLayout(viewN2);
	CtrlLayout(viewS1);
	CtrlLayout(viewS2);

	m_NETab.Add(viewN1,"端口资源");
	m_NETab.Add(viewN2,"查询");

	
	m_CHTab.Add(viewS1,"通路图");
	m_CHTab.Add(viewS2,"查询");
	m_CHTab.Hide();
    
    viewN1.m_AllPorts.MultiSelect();
    viewN1.m_AllPorts.SetSubCount(7);
    viewN1.m_AllPorts.SetTitle("端口树");
    viewN1.m_AllPorts.SetSubTitle(0,"装载");
    viewN1.m_AllPorts.SetSubTitle(1,"交叉");
    viewN1.m_AllPorts.SetSubTitle(2,"类型");
    viewN1.m_AllPorts.SetSubTitle(3,"状态");
    viewN1.m_AllPorts.SetSubTitle(4,"信息");
    viewN1.m_AllPorts.SetSubTitle(5,"电路");
    viewN1.m_AllPorts.SetSubTitle(6,"备注");
    
    viewN1.m_AllPorts.SetWidth(200);
    viewN1.m_AllPorts.SetSubWidth(0,200);
    viewN1.m_AllPorts.SetSubWidth(1,200);  
    viewN1.m_AllPorts.SetSubWidth(2,50);
    viewN1.m_AllPorts.SetSubWidth(3,40);
    viewN1.m_AllPorts.SetSubWidth(4,100);  
    viewN1.m_AllPorts.SetSubWidth(5,200);
    viewN1.m_AllPorts.SetSubWidth(6,50);
	m_NETab.SizePos();m_CHTab.SizePos();
	viewN1.m_AllPorts.WhenAction=THISBACK(Action);	
//	viewN1.m_AllPorts.WhenClose=THISBACK(Action1);
	viewN1.SizePos();viewN2.SizePos();
	viewS1.SizePos();viewS2.SizePos();
}

void URightCtrl::Close()
{
	ClearPorts();
}

void URightCtrl::ShowNE()
{
   m_CHTab.Hide();
   m_NETab.Show();
}

void URightCtrl::ShowCH()
{
   m_NETab.Hide();
   m_CHTab.Show();	
}

bool URightCtrl::ShowPorts(String id)
{
 if(!db.IsDbAlive())return false;
  ClearPorts();
  USQLite3Table tab;
  int cid,parent;
  String sql="select slId,slName,caName from Slot,Card where slCaId=caId and slElId=";
  String Ids,hpIds;
  Vector<Rec>  hp;
  Vector<Rec>  lk;
  try
  {
    //Load Slot  
      sql=sql+id+" order by cast(slName as int);";
      tab=db.data.GetTable(sql);
      for(int row=0;row<tab.numRows();row++)
      {
          tab.setRow(row);
          cid=viewN1.m_AllPorts.Add(0,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
          viewN1.m_AllPorts.SetSubText(cid,0,tab.fieldValue(2));
          Ids=Ids+','+tab.fieldValue(0);
      }
      tab.finalize();
      if(!Ids.IsEmpty())Ids=Ids.Mid(1);
    //Load Ports
      sql="select poId,poName,poSlId,poType,poCpNum,poLiId,poHLPaId,lpName,hpName,liName,hpId,liId \
           from Port left outer join LPath on poHLPaId=lpId \
           left outer join HPath on poHLPaId=hpId \
           left outer join Link on poLiId=liId \
           where poSlId in("+Ids+");";
      tab=db.data.GetTable(sql);
      for(int row=0;row<tab.numRows();row++)
      {
           tab.setRow(row);
           parent=viewN1.m_AllPorts.Find(tab.fieldValue(2));
           if(parent!=-1&&viewN1.m_AllPorts.GetLevel(parent)==1)
           {              
             cid=viewN1.m_AllPorts.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
             viewN1.m_AllPorts.SetSubText(cid,2,tab.fieldValue(3));
             viewN1.m_AllPorts.SetSubText(cid,4,tab.fieldValue(4)+"M");
             if(tab.fieldValue(5)=="0") //is Path then...
             {
               if(tab.fieldValue(4)=="2") viewN1.m_AllPorts.SetSubText(cid,0,tab.fieldValue(7));
                else                           
                {
                   viewN1.m_AllPorts.SetSubText(cid,0,tab.fieldValue(8));
                   hp.Add(Rec(cid,tab.fieldValue(10)));
                }
    
               viewN1.m_AllPorts.SetSubText(cid,3,"NAP");
             }
             
             if(tab.fieldValue(6)=="0") //is Link then...
             {
               viewN1.m_AllPorts.SetSubText(cid,0,tab.fieldValue(9));
               lk.Add(Rec(cid,tab.fieldValue(11)));
               
               viewN1.m_AllPorts.SetSubText(cid,3,"LNK");
             }
           }
           else
           {
               PromptOK("Database corrupt");
	           tab.finalize();   
	           return false;                  
           }                    
      }
      tab.finalize();//Finish port load part
      
    //Load Channel
      if(lk.GetCount()==0) return true;
      Ids=lk[0].Id;
      for(int i=1;i<lk.GetCount();i++) Ids=Ids+','+lk[i].Id;
      sql="select chId,chRow,hpName,hpId,chLiId from Channel left outer join HPath on chHpId=hpId where chLiId in("+Ids+");";
      tab=db.data.GetTable(sql);
      for(int row=0;row<tab.numRows();row++)
      {
           tab.setRow(row);
           parent=FindItembyKey(lk,tab.fieldValue(4));
           if(parent!=-1&&viewN1.m_AllPorts.GetLevel(parent)==2)
           {
              cid=viewN1.m_AllPorts.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),"VC#"+tab.fieldValue(1),false); 
              viewN1.m_AllPorts.SetSubText(cid,0,tab.fieldValue(2));
              viewN1.m_AllPorts.SetSubText(cid,4,"155M");
              if(tab.fieldValue(3)!="0")
               hp.Add(Rec(cid,tab.fieldValue(3)));
           }
      }      
      tab.finalize();
   //Load TimeSlot
      if(hp.GetCount()==0) return true;
      Ids=hp[0].Id;
      for(int i=1;i<hp.GetCount();i++) Ids=Ids+','+hp[i].Id;
      sql="select tsId,tsRow,lpName,tsHpId from TimeSlot left outer join LPath on tsLpId=lpId where tsHpId in("+Ids+");";
      tab=db.data.GetTable(sql);
      for(int row=0;row<tab.numRows();row++)
      {
           tab.setRow(row);
           parent=FindItembyKey(hp,tab.fieldValue(3));
           if(parent!=-1&&((viewN1.m_AllPorts.GetLevel(parent)==2)||(viewN1.m_AllPorts.GetLevel(parent)==3)))
           {
              cid=viewN1.m_AllPorts.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),"VC12#"+tab.fieldValue(1),false); 
              viewN1.m_AllPorts.SetSubText(cid,0,tab.fieldValue(2));
              viewN1.m_AllPorts.SetSubText(cid,4,"2M");
           }
      }      
      tab.finalize();          
      
  }   
  catch(USQLite3Exception &e)
  {
 	   PromptOK(e.errorMessage());
	   tab.finalize(); 
	   return false;          
  }
  return true;
}

void URightCtrl::ClearPorts()
{
   viewN1.m_AllPorts.Clear();	
}

void URightCtrl::Action()
{ 
  //viewN1.m_AllPorts.SetSubText(viewN1.m_AllPorts.GetCursor(),6,AsString(viewN1.m_AllPorts.GetLineAtItem(viewN1.m_AllPorts.GetCursor())));
}

/*void URightCtrl::Action1()
{ 
   PromptOK("Close!");
}*/

int URightCtrl::FindItembyKey(Vector<Rec> &v,String key)
{
	for(int i=0;i<v.GetCount();i++)
	 if(v[i].Id==key)return v[i].item;
	return -1;
}

#endif
