#ifndef _UTL_CTRL_H_
#define _UTL_CTRL_H_

#include <CtrlLib/CtrlLib.h>
#include "UTLCtrl.h"
#define IMAGECLASS UTLImag
#define IMAGEFILE <UVarCtrl/TreeCtrl.iml>
#include <Draw/iml.h>

UTLCtrl::Node::Node()
{
	Init();
}

UTLCtrl::Node::Node(const Image& img,const Image& hotimg, const Value& v)
{
	Init();
	image = img;
	hotimage=hotimg;
	key = value = v;
}

UTLCtrl::Node::Node(const Image& img,const Image& hotimg, const Value& v, const Value& t)
{
	Init();
	image = img;
	hotimage=hotimg;
	key = v;
	value = t;
}


UTLCtrl::Node::Node(const Value& v)
{
	Init();
	key = value = v;
}

UTLCtrl::Node::Node(const Value& v, const Value& t)
{
	Init();
	key = v;
	value = t;
}



UTLCtrl::UTLCtrl()
{
	levelcx = 18;
	rowHeight =24;
	subCnt=0;
	Width=180;
	Title="Tree";
	cursor=0;
	dragPtx=-10;//
	dragCol=-1;//which col is dragging
	isdrag=false;//Is dragging column line
	RMargin=30;//Margin at right side of the table,by Ulti
	dirty = true;
	isselection = false;
	multiselect = false;
	Clear();
	SetFrame(ViewFrame());
	AddFrame(sb);
	sb.WhenScroll = THISBACK(Scroll);
	BackPaint();//Add this to avoid flicker,very useful
}

UTLCtrl::~UTLCtrl() {}

void   UTLCtrl::Layout()
{
	sb.SetPage(GetSize());
	sb.SetLine(rowHeight);
}

Size   UTLCtrl::Item::GetValueSize() const
{
	if(IsNull(size))
	  return display ? display->GetStdSize(value) : StdDisplay().GetStdSize(value);
	else
	  return size;
}

Size   UTLCtrl::Item::GetSize() const
{
	Size sz = GetValueSize();
	sz += Size(2 * margin, 2 * margin);
	Size isz = image.GetSize();
	sz.cx += isz.cx;
	sz.cy = max(sz.cy, isz.cy);
	return sz;
}


int    UTLCtrl::Insert(int parentid, int i, const UTLCtrl::Node& n)//新入节点在父亲的孩子节点中的位置
{
    if(parentid<0||parentid>=item.GetCount())return -1;
     //if() return -1;
	int id;
	if(freelist >= 0) 
	{   //首先看item数组是否有空闲位置,如有,新插入的Node放在该位置
		id = freelist;
		freelist = item[id].freelink;
	}
	else 
	{ //如果没有,就新加一个位置
		id = item.GetCount();
		item.Add();
	}
	
	Item& m = item[id];
	m.parent = parentid;
	for(int ii=0;ii<subCnt;ii++)
	  m.subText.Add("");
	(UTLCtrl::Node&)m = n;
	
	
    Item& parent = item[parentid];
	parent.child.Insert(i, id);
	Dirty(parentid);
	return id;
}

int    UTLCtrl::Add(int parentid, const UTLCtrl::Node& n)
{
	return Insert(parentid, item[parentid].child.GetCount(), n);
}

int    UTLCtrl::Insert(int parentid, int i)
{
	return Insert(parentid, i, UTLCtrl::Node());
}

int    UTLCtrl::Add(int parentid)
{
	return Add(parentid, UTLCtrl::Node());
}

int    UTLCtrl::Insert(int parentid, int i, const Image& img,const Image& hotimg, Value v, bool withopen)
{
	return Insert(parentid, i, UTLCtrl::Node(img,hotimg,v).CanOpen(withopen));
}

int    UTLCtrl::Insert(int parentid, int i, const Image& img,const Image& hotimg, Value v, Value t, bool withopen)
{
	return Insert(parentid, i, UTLCtrl::Node(img,hotimg,v,t).CanOpen(withopen));
}

int    UTLCtrl::Add(int parentid, const Image& img,const Image& hotimg, Value v, bool withopen)
{
	return Add(parentid, UTLCtrl::Node(img,hotimg,v).CanOpen(withopen));
}

int    UTLCtrl::Add(int parentid, const Image& img,const Image& hotimg, Value v, Value t, bool withopen)
{
	return Add(parentid, UTLCtrl::Node(img,hotimg, v, t).CanOpen(withopen));
}


Value  UTLCtrl::Get(int id) const //Get返回的是KEY
{
	const Item& m = item[id];
	return m.key;
}

Value  UTLCtrl::GetValue(int id) const //GetValue才返回值
{
	const Item& m = item[id];
	return m.value;
}

void  UTLCtrl::Set(int id, Value v) //设置KEY的值
{
	Item& m = item[id];
	m.value = m.key = v;
	RefreshItem(id);
}

void  UTLCtrl::Set(int id, Value k, Value v) //设置KEY和值
{
	Item& m = item[id];
    m.key = k;
    m.value = v;
	RefreshItem(id);
}

void   UTLCtrl::SetNode(int id, const UTLCtrl::Node& n)//设置节点
{
	(UTLCtrl::Node&)item[id] = n;
	Dirty(id);
}

void   UTLCtrl::RemoveChildren(int id)//删除id的孩子节点,不难理解
{
	Item& m = item[id];
	for(int i = 0; i < m.child.GetCount(); i++)
		RemoveSubtree(m.child[i]);
	m.child.Clear();
	
	Dirty(id);
}

void   UTLCtrl::RemoveSubtree(int id)//删除id极其子节点,未处理其在父节点中的信息
{
	Item& m = item[id];
	if(m.linei == cursor)
		cursor = item[m.parent].linei;//先把光标移到父节点
	m.value = Null;
	m.image = Null;
	m.hotimage=Null;
	m.subText.Clear();
	RemoveChildren(id);//删除其孩子节点
	m.freelink = freelist;//该内存位置加到空闲列表
	freelist = id;
}

void   UTLCtrl::Remove(int id)//删除id极其子节点,同时删除其在父节点中的信息
{
	ASSERT(id > 0);
	int pi = item[id].parent;
	Item& parent = item[item[id].parent];
	parent.child.Remove(FindIndex(parent.child, id));//删除其在父亲中的信息
	RemoveSubtree(id);
	Dirty(pi);
}

void   UTLCtrl::Clear()//清除全部,重置为空,加item[0]
{
	item.Clear();
	line.Clear();
	item.Add();
	item[0].linei=-1;
	item[0].parent=-1;
	item[0].isopen=true;
	freelist=-1;
	cursor=-1;
	Dirty();
	
}


// revised version by Ulti,used only for fixed height rows treelist
void UTLCtrl::ReLine(int itemi, int level)
{
	int ii = line.GetCount();
	Item& m = item[itemi];
	Line& l = line.Add();
	l.level = level;
	l.itemi = itemi;
    l.ll = -1;
	m.linei = ii;
	level++;
	
	if(m.isopen)
	{
	  for(int i = 0; i < m.child.GetCount(); i++)
	  {
		 line[ii].ll = line.GetCount();
		 ReLine(m.child[i],level);
	  }
	}	
}

//revised version by Ulti,used only for fixed height rows treelist
void UTLCtrl::SyncTree()//同步树
{
	if(!dirty)//没有更新,不需同步
		return;
	int cursorid = GetCursor();
	for(int i = 0; i < item.GetCount(); i++)
		item[i].linei = -1;
	line.Clear();//行与项的关联重置
	ReLine(0, -1);
	cursor = -1;
	dirty = false;
	if(cursorid >=0)
		SetCursor(cursorid, false);
}

bool UTLCtrl::IsOpen(int id) const//是否打开
{
	return item[id].isopen;
}

void UTLCtrl::Dirty(int id)
{
	ClearSelection();
	Size sz = GetSize();
	dirty = true;
	while(id > 0) 
	{
		int q = item[id].linei;
		if(q > 0) 
		{
			int y = q*rowHeight- sb.GetY();//revised by Ulti
			Refresh(0, y, sz.cx, sz.cy - y);
			return;
		}
		id = item[id].parent;
	}
	Refresh();
}

void UTLCtrl::Open(int id, bool open)
{
 //   if(id<0||id>=item.GetCount()||item.GetCount()==1)return;
   // if(IsFreeItem(id)) return;
    
	Item& m = item[id];

	if(m.isopen != open) 
	{
		m.isopen = open;
		int q = GetCursor();
		while(q > 0) 
		{
			if(q == id) 
			{
				SetCursor(id);
				break;
			}
			q = GetParent(q);
		}
	
		Dirty(id);
	
		if(open)
			WhenOpen(id);
		else
			WhenClose(id);
	}
}

void UTLCtrl::OpenDeep(int id, bool open)
{
	Open(id);
	Item& m = item[id];
	for(int i = 0; i < m.child.GetCount(); i++)
		OpenDeep(m.child[i], open);
}

void UTLCtrl::MakeVisible(int id)
{
	if(id<1||id>=item.GetCount())return;
	id=GetParent(id);
	while(id > 0) 
	{
		Open(id);
		id = GetParent(id);
	}
}

int UTLCtrl::FindLine(int y) const
{
	int l=y/rowHeight;
	return l>line.GetCount()?-1:l>0 ? l : -1;//-1:表示超出了界限
}

void UTLCtrl::RefreshLine(int i)//刷新行
{
	SyncTree();
	if(i >= 1&&i<line.GetCount()) 
	{
		Size sz = GetSize();
		int y = i*rowHeight-sb.GetY();//revised by Ulti
		Refresh(0, y, sz.cx,rowHeight);
	}
}

void UTLCtrl::RefreshItem(int id)//刷新项
{
	SyncTree();
	if(IsFreeItem(id)) return;
	RefreshLine(item[id].linei);
}




void UTLCtrl::SetCursorLine(int i, bool sc)//sc表示是否滚动到光标行
{
	if(i!=cursor) 
	{
		i=minmax(i,0,line.GetCount()-1);
		if(i<=0) return;
		Item& m=item[line[i].itemi];
		if(sc)
			sb.ScrollIntoY(i*rowHeight, rowHeight);//revised by Ulti
		RefreshLine(cursor);
		cursor=i;	
		RefreshLine(cursor);
		WhenCursor();
	}
}

void UTLCtrl::SetCursorLine(int i)
{
	SetCursorLine(i, true);
}

void UTLCtrl::SetCursorLineSync(int i)//only used in Key function
{
	int ud=i<cursor?-1:1;
	if(i!=cursor) 
	{
		if(cursor<1)
			Refresh();
		else
		    RefreshLine(cursor);
    	cursor = minmax(i,0, line.GetCount() - 1);
    	if(cursor<=0)
    	{
    		cursor=0;
    		Refresh();	
    	}
		else 
		{
		    RefreshLine(cursor);
			Sync();	
			sb.ScrollIntoY((cursor+ud)*rowHeight,rowHeight);//revised by Ulti
		}
		SetFocus();
		WhenCursor();
	}
}

void UTLCtrl::KillCursor()
{
	RefreshLine(cursor);
	cursor = -1;
	Refresh();
	WhenCursor();
}

void UTLCtrl::SetCursor(int id, bool sc)
{
	while(id>0) 
	{
		ASSERT(id >= 0 && id < item.GetCount());
		if(IsFreeItem(id)) return;
		MakeVisible(id);
		SyncTree();
		const Item& m = item[id];
		if(m.linei > 0) 
		{
			SetCursorLine(m.linei, sc);
			return;
		}
		id = m.parent;
	}
	SetCursorLine(-1, sc);
}

void UTLCtrl::SetCursor(int id)
{
	SetCursor(id, true);
}

int  UTLCtrl::GetCursor() const
{
	return (cursor > 0 &&cursor<line.GetCount())? line[cursor].itemi : -1;
}

Value  UTLCtrl::Get() const
{
	return IsCursor() ? Get(GetCursor()) : Value();
}

Value  UTLCtrl::GetValue() const
{
	return IsCursor() ? GetValue(GetCursor()) : Value();
}

int    UTLCtrl::Find(Value key)
{
	for(int i = 1; i < item.GetCount(); i++)
		if(Get(i) == key)
			return i;
	return -1;
}

bool   UTLCtrl::FindSetCursor(Value key)
{
	int q = Find(key);
	if(q <=0)
		return false;
	SetCursor(q);
	return true;
}

void UTLCtrl::ShiftSelect(int l1, int l2)
{
	if(!multiselect)
		return;
	bool b = false;
	if(l1 > l2)
		Swap(l1, l2);
	for(int i = l1; i <= l2; i++)
		SelectOne(line[i].itemi, true,true);
	UpdateSelect();
}

void UTLCtrl::LeftDown(Point p, dword flags)
{
	Point org = sb;
   
    if(p.y<0||p.y>=(line.GetCount())*rowHeight-org.y||p.x>Right()||p.x<0)return;
    SetFocus();
    if(p.y<rowHeight)
    {
        if(ShowDragArrow(p)) SetCapture();
    }
    else
    {
 	   int i = FindLine(p.y + org.y);
 	   if(i<=0||i>=line.GetCount()) return;
	   const Line& l = line[i];
	   int x = levelcx + l.level * levelcx -(levelcx>>1);
	
	   if(p.x > x -(levelcx>>1)+1 && p.x < x + (levelcx>>1)-1)
	   {
		   Open(l.itemi, !IsOpen(l.itemi));
	   }
	   else
	   {//后面的选择太慢,需要检查
		  int q = cursor;
		  SetCursorLine(i);
		  if(cursor != q)
		    WhenAction();
		  int id = GetCursor(); 
				     
		  if((flags & K_CTRL)&&multiselect) 
		  {    
	         SelectOne(id, !IsSelected(id),true);
		  }	
		  else 
		   if((flags & K_SHIFT)&&multiselect) 
		    {
			   ClearSelection();
			   if(q==-1) q=cursor;
			   ShiftSelect(q, cursor);
			   cursor = q;
		    }
		    else SelectOne(id,true);
		} 
    }
}

void UTLCtrl::LeftDouble(Point p, dword flags)
{
	Point org = sb;
    if(p.y<rowHeight||p.y>=(line.GetCount())*rowHeight-org.y||p.x>Right()||p.x<0)return;
    int i = FindLine(p.y + org.y);
    const Line& l = line[i];
    Open(l.itemi, !IsOpen(l.itemi));
	WhenLeftDouble();	
}

void UTLCtrl::RightDown(Point p, dword flags)
{
/*	Point org = sb;
	if(p.y + org.y < sb.GetTotal().cy) {
		int i = FindLine(p.y + org.y);
		if(i >0) {
			SetFocus();
			SetCursorLine(i);
		}
	}
	if(WhenBar)
		MenuBar::Execute(WhenBar);*/
}

void UTLCtrl::Paint(Draw& w)
{
	SyncTree();
	Size sz = GetSize();
	Point org = sb;
	scroller.Set(org);
	w.DrawRect(sz, SColorPaper);
   
	int levelcx2 = (levelcx >> 1);
	int halfRow = (rowHeight >> 1); 
 	
    const Display *d = &StdDisplay();
    int Col=FirstCol();
	w.DrawRect(0,rowHeight-org.y,Width,(line.GetCount()-1)*rowHeight,SWhiteGray());//Draw tree background
	for(int i=0;i<line.GetCount();i++) 
	{	
    	Line& l = line[i];
		const Item& m = item[l.itemi];
		Size msz = m.GetSize();
		Size isz = m.image.GetSize();
		Size vsz = m.GetValueSize();
		int y = i*rowHeight+halfRow- org.y;//let the tree item is in the middle of a row
		int x = levelcx + l.level * levelcx+ levelcx2;
	    Color fg = SColorText;
	    Color bg = SWhiteGray();
	    Color tbg=SColorPaper;
	    Color tfg = SColorText;
		if(m.sel) 
		{
		   fg = SColorMark;
		   tfg = SColorHighlightText;
		   bg =  SWhite ;
		   tbg = SColorHighlight ;
		}
		else
		 if(i == cursor) 
		 {
		   tbg =  SLtYellow();
		 }
		 
		if(l.ll >0) 
		{
			int yl = i*rowHeight+halfRow - org.y;
			int yh = l.ll*rowHeight+halfRow - org.y;
			if(yh >0 && yl < sz.cy) 
			{
				w.DrawRect(x, yl, 1, yh - yl, SGreen());
			}
		} 

		if(y <=sz.cy&&i>=FindLine(org.y+rowHeight)) 
	    {  	  
    	  Point op = Point(x - levelcx, y );//draw horiz lines
		  w.DrawRect(op.x, op.y, levelcx, 1,SGreen());
		  if(m.canopen || m.child.GetCount()) 
		  {
				Image im = m.isopen ? UTLImag::UTLExpend():UTLImag::UTLCollapse();
				op -= (im.GetSize()>>1);
				w.DrawImage(op.x, op.y, im);
		  }
		  w.DrawImage(x-isz.cx/2, y - (isz.cy>>1), m.sel?m.hotimage:m.image);
		  x += isz.cx;
		  w.DrawRect(x, y - (msz.cy>>1), vsz.cx + (1<<m.margin), msz.cy, bg);
		  d->Paint(w, RectC(x + m.margin, y - (vsz.cy>>1), vsz.cx, vsz.cy), m.value,fg, bg,0);
		  
		  int cellx=Width;
		  if(Col!=subCnt)
		  {
		      for(int j=Col;j<subCnt;j++)
		     {
		        d->Paint(w,RectC(cellx+1,i*rowHeight+1-org.y,subWidth[j],rowHeight-1),
		                 m.subText[j],tfg,tbg,0);
		        cellx+=subWidth[j];        
		     }
		  }
		  w.DrawRect(0,(i+1)*rowHeight-org.y,cellx,1,SLtGray());//by Ulti,Draw bottom horiz line of the table row				
	     }
	}
	
	w.DrawRect(Width,-org.y,1,line.GetCount()*rowHeight,SLtGray());//Right line of the the tree

   // w.DrawRect(0,0,Width,rowHeight,SColorFace);//title row
	d->Paint(w,RectC(0,0,Width,rowHeight),Title,SColorText,SColorFace,0);//first cell in title row
	
	int lx=Width;
	if(Col!=subCnt)
	{
	  for(int m=FirstCol();m<subCnt;m++)
	  {
	    d->Paint(w,RectC(lx+1,0,subWidth[m],rowHeight),subTitle[m],SColorText,SColorFace,0);
	    lx+=subWidth[m];
	    w.DrawRect(lx,-org.y,1,line.GetCount()*rowHeight,SLtGray());
	  }
	}
	w.DrawRect(Rect(lx+1,0,sz.cx,line.GetCount()*rowHeight-org.y),SColorPaper);
	w.DrawRect(0,rowHeight,lx,1,SLtGray());//bottom line of title
	
    if(isdrag)
    {
      w.DrawRect(dragPtx,0,1,sz.cy,SColorHighlight());
      isdrag=false;
    }
}

void UTLCtrl::Scroll()
{
	SyncTree();
	scroller.Scroll(*this, sb);
	Refresh();
}

void UTLCtrl::MouseWheel(Point, int zdelta, dword)
{
	sb.WheelY(zdelta);
}

void UTLCtrl::ChildGotFocus()
{
	for(int i = 0; i < line.GetCount(); i++) {
		Item& m = item[line[i].itemi];
	}
}

bool UTLCtrl::Tab(int d)
{
	if(cursor < 0)
		return false;
	Item& m = item[line[cursor].itemi];

	int i = cursor;
	for(int i = cursor + d; i >= 0 && i < line.GetCount(); i += d) {
		Item& m = item[line[i].itemi];
	}
	return false;
}

bool UTLCtrl::Key(dword key, int)
{
	SyncTree();
	Size sz = GetSize();
	int cid = GetCursor();
	bool shift = key & K_SHIFT;
	key &= ~K_SHIFT;
	switch(key) {
	case K_TAB:
		return Tab(1);
	case K_SHIFT_TAB:
		return Tab(-1);
	case K_UP:
		SetCursorLineSync(cursor > 1 ? cursor - 1 : 1);
		break;
	case K_DOWN:
		SetCursorLineSync(cursor >= 1 ? cursor + 1 : line.GetCount() - 1);
		break;
	case K_PAGEDOWN:
	    {
		 int vl=FindLine(cursor*rowHeight+1+ sz.cy);
		 SetCursorLineSync(cursor >= 1 ? vl==-1?line.GetCount()-1:vl:line.GetCount()-1 );
		}break;
	case K_PAGEUP:
	    {
	      int vl=FindLine(cursor*rowHeight+1-sz.cy);   
		  SetCursorLineSync(cursor >=1?vl==-1?1:vl:1);
		}break;
	case K_LEFT:
		if(cid > 0)
			Close(cid);
		break;
	case K_RIGHT:
		if(cid > 0)
			Open(cid);
		break;
	default:
		return false;
	}
	if(cid != cursor)
		if(shift && multiselect)
			ShiftSelect(cid, cursor);
		else
			ClearSelection();
	if(cursor != cid)
		WhenAction();
	return true;
}

void UTLCtrl::GotFocus()
{
	if(dirty)
		return;
	RefreshLine(cursor);
}

void UTLCtrl::LostFocus()
{
	if(dirty)
		return;
	RefreshLine(cursor);
}

void UTLCtrl::ChildRemoved(Ctrl *)
{
	Dirty();
}

void  UTLCtrl::SetData(const Value& data)
{
	FindSetCursor(data);
}

Value UTLCtrl::GetData() const
{
	return Get();
}

Point  UTLCtrl::GetScroll() const
{
	return sb;
}

void UTLCtrl::ScrollTo(Point sc)
{
	sb = sc;
}

void UTLCtrl::ClearSelTree(int id)
{
	Item& m = item[id];
	m.sel = false;
	for(int i = 0; i < m.child.GetCount(); i++)
		ClearSelTree(m.child[i]);
}

void UTLCtrl::ClearSelection()
{
	if(isselection) {
		ClearSelTree(0);
		isselection = false;
		WhenSelection();
		WhenAction();
		Refresh();
	}
}

bool UTLCtrl::UpdateSelTree(int id)
{
	Item& m = item[id];
	if(m.sel)
		return true;
	for(int i = 0; i < m.child.GetCount(); i++)
		if(UpdateSelTree(m.child[i]))
			return true;
	return false;
}

void UTLCtrl::UpdateSelect()
{
	isselection = UpdateSelTree(0);
	WhenSelection();
	WhenAction();
}

void UTLCtrl::SelectOne(int id, bool sel,bool multi)
{

	if(!multi)
	{
	    ClearSelection();  	
	}
	if(item[id].canselect)
	item[id].sel = sel; 
	UpdateSelect();
	RefreshItem(id); 
}

void UTLCtrl::MouseMove(Point p, dword keyflags) 
{
 int col=FirstCol();
 if(!HasCapture())
  {
     int xx=Width;
     if(p.y>0&&p.y<rowHeight)
     {
        if(p.x>xx-8&&p.x<xx+8)
        {
          dragPtx=p.x;
          dragCol=subCnt;
        }
        else
        {
          for(int ii=col;ii<subCnt;ii++)
          {
            xx+=subWidth[ii];
            if(p.x>xx-8&&p.x<xx+8)
            {
              dragPtx=p.x;
              dragCol=ii;
              break;
            }
           }
          }
        }
  }
  else
  {
      if(dragCol==-1) return;
      Size sz;
      sz=GetSize();
      if(dragCol==subCnt) 
      {
        if(p.x<10) p.x=10;
        if(p.x>(sz.cx>>1))p.x=(sz.cx>>1);
        Width=p.x;
        dragPtx=p.x;
      }
      else
      {
        if(p.x>sz.cx-10) dragPtx=sz.cx-10;
        else
        {
           int tx=Width;
           for(int nn=col;nn<dragCol;nn++)
           {
               tx+=subWidth[nn];
           }
           if(p.x<tx+20)
               dragPtx=tx+20;
             else dragPtx=p.x;
           subWidth[dragCol]+=(dragPtx-(tx+subWidth[dragCol]));
        }
      }
      isdrag=true;
      Refresh();
  }
}

void UTLCtrl::LeftUp(Point p, dword keyflags) 
{//release left button
	Refresh(dragPtx-2,0,4,GetSize().cy);
	if(dragCol!=-1)
	{
      dragPtx=-10;
      dragCol=-1;
     // SetSBSize();
	}	
}


Image UTLCtrl::CursorImage(Point p, dword keyflags) 
{//show cursor
    return ShowDragArrow(p)?Image::SizeHorz():Image::Arrow();
}

int UTLCtrl::GetSumWidth()//get sum of col width
{
	return GetSumWidth(subCnt-1);
}
int UTLCtrl::GetSumWidth(int sub)//get sum of colwith(col 0~col)
{
	if(sub<0) return 0;
	int n=sub;
	if(n>=subCnt)n=subCnt-1;
	int w=0;
	for(int i=0;i<=n;i++) w+=subWidth[i];
	return w;
}

void UTLCtrl::SetSubCount(int cnt)//set column count
{
	if(cnt<0||cnt>1000) return;
	subCnt=cnt;
	for(int i=0;i<subCnt;i++)
	{
		subWidth.Add(50);
		subTitle.Add("");	
	}
}



void UTLCtrl::SetSubWidth(int sub,int width)//set width of one of col
{
	if(sub<0||sub>=subCnt) return;
	subWidth[sub]=width>20?width:20;	
	SetSBSize();
}

void UTLCtrl::SetSubTitle(int sub,String title)//set column title
{
	if(sub<0||sub>=subCnt) return;
	subTitle[sub]=title;
}

void UTLCtrl::SetSubText(int id,int sub,String txt)//set tree subitem text
{
	if(sub<0||sub>=subCnt)return;
	item[id].subText[sub]=txt;	
}

bool UTLCtrl::ShowDragArrow(Point p)//is that show drag cursor?
{
   return (p.x>dragPtx-2&&p.x<dragPtx+2)?true:false;
}

void UTLCtrl::SetSBSize()//set scroller total size,called when syntree and and when you drag column width
{
	Size sz;
	sz=GetSize();
    sz.cy=(line.GetCount()+1)*rowHeight;
    int tx=GetSumWidth()+Width;
    
	sz.cx=(tx<sz.cx)?Right():Right()+sz.cx;
	sb.SetTotal(sz);//这里是让滚动条工作的关键	
	
}



int UTLCtrl::GetLevel(int id)//get the level of item[id],by Ulti
{
    if(id==0) return 0;
    if(id<0||id>=item.GetCount()) return -1;
    return GetLevel(GetParent(id))+1;
}

bool UTLCtrl::IsFreeItem(int id)//if item[id] is free,not a valuable item,by Ulti
{
	if(id<0||id>item.GetCount()) return true;
	if(id==freelist) return true;
	int f=freelist;
	while(f!=-1)
	{
		if(item[f].freelink==id) return true;
		f=item[f].freelink;
	}
	return false;
}

int UTLCtrl::FirstCol()
{
	int i;
	for(i=0;i<subCnt;i++)
	{
	  if(GetSumWidth(i)-sb.GetX()>0) break; 
	}
	return i;
}

int UTLCtrl::Right()
{
	int n=FirstCol();
	int x=Width;
	for(int i=n;i<subCnt;i++)
		x+=subWidth[i];
	return x;
}

#endif
