#ifndef _OPath_LeftCtrl_h
#define _OPath_LeftCtrl_h

#include <CtrlLib/CtrlLib.h>

#define LAYOUTFILE <OPath/OPath.lay>
#include <CtrlCore/lay.h>
#include "RightCtrl.h"


class ULeftCtrl : public WithULeftCtrl<TopWindow> {
public:

	typedef ULeftCtrl CLASSNAME;
    void    show();
    void    ShowItem();
    void SearchUT();
	ULeftCtrl();
	URightCtrl* right;
	bool  LoadTree();
	bool  RootTree();
	private:
	int     ActiveUT;
	
};

ULeftCtrl::ULeftCtrl()
{
	SetFrame(RightSeparatorFrame()/*ViewFrame()*/);
	CtrlLayout(*this, "");
    
    m_Switcher.Add(m_Tree,OPathImg::NE(),"网元");
    m_Switcher.Add(m_Tree1,OPathImg::CH(),"通路");
    m_Tree.SetFrame(ViewFrame());
    m_Tree1.SetFrame(ViewFrame());
    RootTree();
	
    ActiveUT=0;//Current active tree
    m_Switcher.WhenAction=THISBACK(show);
    btn_SearchUT.WhenAction=THISBACK(SearchUT);
    m_Tree.WhenAction=THISBACK(ShowItem);
    m_Tree.SizePos();
    m_Tree1.SizePos();
}

void ULeftCtrl::show()
{
	ActiveUT=m_Switcher.Get();
    switch(ActiveUT)
    {
	   case 0:right->ShowNE();break;
	   case 1:right->ShowCH();break;
    }	
}

void ULeftCtrl::ShowItem()
{
	ActiveUT=m_Switcher.Get();
    switch(ActiveUT)
    {
	   case 0:
	   {
	       int cursor=m_Tree.GetCursor();
	       if(m_Tree.GetLevel(cursor)==4&&cursor!=-1)
	       {
	           if(!right->ShowPorts(m_Tree.Get(cursor)))
	           {PromptOK("can't load slots of NE.");}
	       }
	   }break;
	   case 1:right->ShowCH();break;
    }	
}

void ULeftCtrl::SearchUT()
{
  switch(ActiveUT)
  {
      case 0:
      {
          if(!m_Tree.FindSetCursor(edt_SearchUT.GetData())) PromptOK("“"+AsString(edt_SearchUT.GetData())+"” not found.");
      }break;
      case 1:
      {
          m_Tree1.FindSetCursor(edt_SearchUT.GetData());
      }break;
      default:;
  }
}

bool ULeftCtrl::LoadTree()
{
	if(!db.IsDbAlive())return false;
    USQLite3Table tab;
    int parent=-1;	
    try
    {
        tab=db.data.GetTable("select siId,siName from Site where siLevel='1' order by siPrior;");
        for(int row=0;row<tab.numRows();row++)
        {
            tab.setRow(row);
            m_Tree.Add(0,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);    
        }
        tab.finalize();
        
        tab=db.data.GetTable("select siId,siName,siSiId from Site where siLevel='2' order by siPrior;");
        for(int row=0;row<tab.numRows();row++)
        {
           tab.setRow(row);
           parent=m_Tree.Find(tab.fieldValue(2));
           if(parent!=-1&&m_Tree.GetLevel(parent)==1)
           {       
              m_Tree.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
           }
           else
           {
               PromptOK("Database corrupt");
	           tab.finalize();   
	           return false;                  
           }
        }
        tab.finalize();

        tab=db.data.GetTable("select siId,siName,siSiId from Site where siLevel='3' order by siPrior;");
        for(int row=0;row<tab.numRows();row++)
        {
           tab.setRow(row);
           parent=m_Tree.Find(tab.fieldValue(2));
           if(parent!=-1&&m_Tree.GetLevel(parent)==2)
           {                  
              m_Tree.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
           }
           else
           {
               PromptOK("Database corrupt");
	           tab.finalize();   
	           return false;                  
           }           
        }
        tab.finalize();
        
        tab=db.data.GetTable("select elId,elName,elSiId from Element order by elName;");
        for(int row=0;row<tab.numRows();row++)
        {
           tab.setRow(row);
           parent=m_Tree.Find(tab.fieldValue(2));
           if(parent!=-1&&m_Tree.GetLevel(parent)==3)
           {              
             m_Tree.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
           }
           else
           {
               PromptOK("Database corrupt");
	           tab.finalize();   
	           return false;                  
           }           
        }
        tab.finalize(); 
 
        tab=db.data.GetTable("select ssId,ssName from SysSet;");
        for(int row=0;row<tab.numRows();row++)
        {
            tab.setRow(row);
            m_Tree1.Add(0,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
        }
        tab.finalize(); 

        tab=db.data.GetTable("select syId,syName,sySsId from System order by syName;");
        for(int row=0;row<tab.numRows();row++)
        {
           tab.setRow(row);
           parent=m_Tree1.Find(tab.fieldValue(2));
           if(parent!=-1&&m_Tree1.GetLevel(parent)==1)
           {              
             m_Tree1.Add(parent,OPathImg::USelPort(),OPathImg::SelPort(),tab.fieldValue(0),tab.fieldValue(1),false);
           }
           else
           {
               PromptOK("Database corrupt");
	           tab.finalize();   
	           return false;                  
           }           
        }
        tab.finalize(); 
                    
        m_Tree.Open(0);
        m_Tree1.Open(0);
    }
    catch(USQLite3Exception &e)
    {
 	   PromptOK(e.errorMessage());
	   tab.finalize(); 
	   return false;          
    }
    
    return true;
}

bool ULeftCtrl::RootTree()
{
   m_Tree.Clear();
   m_Tree.SetRoot(OPathImg::USelPort(),OPathImg::SelPort(),"站点/网元");
   m_Tree1.Clear();
   m_Tree1.SetRoot(OPathImg::USelPort(),OPathImg::SelPort(),"系统/通路");
   return true;
}

#endif

