//USQLite3.h
//modified from CppSQLite3.h
//modified from Rob Groves's CppSQLite3.h,see http://www.codeproject.com/database/CppSQLite.asp
//main changes:replaced char* with U++ String;remove "static const bool DONT_DELETE_MSG=false;"
//delete Binary class the encode function.
//by Ulti 2006.09.12


#ifndef _USQLite3_H_
#define _USQLite3_H_
#include <Core/Core.h>
#include "SQLite/sqlite3.h"

//#include <cstdio>
//#include <cstring>

#define USQLITE3_ERROR 1000

class USQLite3Exception
{
public:

    USQLite3Exception(const int nErrCode,
                    String szErrMess);

    USQLite3Exception(const USQLite3Exception&  e);

    virtual ~USQLite3Exception();

    const int errorCode() { return mnErrCode; }

    const String errorMessage() { return mpszErrMess; }

    static const String errorCodeAsString(int nErrCode);

private:

    int mnErrCode;
    String mpszErrMess;
};


class USQLite3Query
{
public:

    USQLite3Query();

    USQLite3Query(const USQLite3Query& rQuery);

    USQLite3Query(sqlite3* pDB,
				sqlite3_stmt* pVM,
                bool bEof,
                bool bOwnVM=true);

    USQLite3Query& operator=(const USQLite3Query& rQuery);

    virtual ~USQLite3Query();

    int numFields();

    int fieldIndex(const String szField);
    const String fieldName(int nCol);

    const String fieldDeclType(int nCol);
    int fieldDataType(int nCol);

    const String fieldValue(int nField);
    const String fieldValue(const String szField);

    int getIntField(int nField, int nNullValue=0);
    int getIntField(const String szField, int nNullValue=0);

    double getFloatField(int nField, double fNullValue=0.0);
    double getFloatField(const String szField, double fNullValue=0.0);

    const String getStringField(int nField, const String szNullValue="");
    const String getStringField(const String szField, const String szNullValue="");

    const String getBlobField(int nField, int& nLen);
    const String getBlobField(const String szField, int& nLen);

    bool fieldIsNull(int nField);
    bool fieldIsNull(const String szField);

    bool eof();

    void nextRow();

    void finalize();

private:

    void checkVM();

	sqlite3* mpDB;
    sqlite3_stmt* mpVM;
    bool mbEof;
    int mnCols;
    bool mbOwnVM;
};


class USQLite3Table
{
public:

    USQLite3Table();

    USQLite3Table(const USQLite3Table& rTable);

    USQLite3Table(char** paszResults, int nRows, int nCols);

    virtual ~USQLite3Table();

    USQLite3Table& operator=(const USQLite3Table& rTable);

    int numFields();

    int numRows();

    const String fieldName(int nCol);

    const String fieldValue(int nField);
    const String fieldValue(const String szField);

    int getIntField(int nField, int nNullValue=0);
    int getIntField(const String szField, int nNullValue=0);

    double getFloatField(int nField, double fNullValue=0.0);
    double getFloatField(const String szField, double fNullValue=0.0);

    const String getStringField(int nField, const String szNullValue="");
    const String getStringField(const String szField, const String szNullValue="");

    bool fieldIsNull(int nField);
    bool fieldIsNull(const String szField);

    void setRow(int nRow);

    void finalize();

private:

    void checkResults();

    int mnCols;
    int mnRows;
    int mnCurrentRow;
    char** mpaszResults;
};


class USQLite3Statement
{
public:

    USQLite3Statement();

    USQLite3Statement(const USQLite3Statement& rStatement);

    USQLite3Statement(sqlite3* pDB, sqlite3_stmt* pVM);

    virtual ~USQLite3Statement();

    USQLite3Statement& operator=(const USQLite3Statement& rStatement);

    int execDML();

    USQLite3Query execQuery();

    void bind(int nParam, const String szValue);
    void bind(int nParam, const int nValue);
    void bind(int nParam, const double dwValue);
    void bind(int nParam, const String blobValue, int nLen);
    void bindNull(int nParam);

    void reset();

    void finalize();

private:

    void checkDB();
    void checkVM();

    sqlite3* mpDB;
    sqlite3_stmt* mpVM;
};


class USQLite3DB
{
public:

    USQLite3DB();

    virtual ~USQLite3DB();

    void Open(const String szFile);

    void Close();

	bool TableExist(const String szTable);

    int ExeDML(const String szSQL);

    USQLite3Query ExeQuery(const String szSQL);

    int ExeScalar(const String szSQL);

    USQLite3Table GetTable(const String szSQL);

    USQLite3Statement CompileStatement(const String szSQL);

    sqlite_int64 LastRowId();

    void Interrupt() { sqlite3_interrupt(mpDB); }

    void SetBusyTimeout(int nMillisecs);

    String SQLiteVersion() { return SQLITE_VERSION; }

private:

    USQLite3DB(const USQLite3DB& db);
    USQLite3DB& operator=(const USQLite3DB& db);

    sqlite3_stmt* compile(const String szSQL);

    void checkDB();

    sqlite3* mpDB;
    int mnBusyTimeoutMs;
};

class USQLite3Buffer
{
public:

    USQLite3Buffer();

    ~USQLite3Buffer();

    const String format(const String szFormat, ...);

    operator const char*() { return mpBuf; }

    void clear();

private:

    String mpBuf;
};

#endif
