
class UTLCtrl : public Ctrl {
public:
	virtual void  Paint(Draw& w);
	virtual void  Layout();
	virtual void  LeftDown(Point p, dword flags);
	virtual void  LeftDouble(Point p, dword flags);
	virtual void  RightDown(Point p, dword flags);
    virtual void  MouseMove(Point p, dword keyflags);
    virtual Image CursorImage(Point p, dword keyflags);
	
	virtual void  LeftUp(Point, dword);
	virtual void  MouseWheel(Point p, int zdelta, dword keyflags);
	virtual bool  Key(dword key, int);
	virtual void  GotFocus();
	virtual void  LostFocus();
	virtual void  ChildGotFocus();
	virtual void  ChildRemoved(Ctrl *);
	virtual void  SetData(const Value& data);
	virtual Value GetData() const;

public:
	class Node
	{
		void           Init() { display = NULL; size = Null; margin = 2; canopen = false; canselect = true; }

	public:
		Image          image;
		Image          hotimage;
		int            margin;
		Value          key;
		Value          value;
		const Display *display;
		Size           size;


		bool           canopen;
		bool           canselect;

		Node& SetImage(const Image& img,const Image& hotimag)          { image = img;hotimage = hotimag; return *this; }
		Node& Set(const Value& v)                 { key = value = v;  return *this; }
		Node& Set(const Value& v, const Value& t) { key = v; value = t; return *this; }
		Node& SetDisplay(const Display& d)        { display = &d;  return *this; }
		Node& SetSize(Size sz)                    { size = sz; return *this; }
		Node& CanOpen(bool b = true)              { canopen = b; return *this; }
		Node& CanSelect(bool b)                   { canselect = b; return *this; }

		Node();
		Node(const Image& img, const Image& hotimg,const Value& v);
		Node(const Image& img, const Image& hotimg,const Value& v, const Value& t);
		
		Node(const Value& v);
		Node(const Value& v, const Value& t);
		
	};

private:
	struct Item : Node {
		union {
			int            parent;
			int            freelink;
		};

		bool           isopen;
		bool           sel;
		Array<String>  subText;//sub item text description,by Ulti
		Vector<int>    child;
		int            linei;
 
		Size GetValueSize() const;
		Size GetSize() const;
        
		Item() { isopen = false; linei = -1; parent = -1; canselect = true; sel = false; }
	};
	struct Line : Moveable<Line> {
		int  level;
		int  itemi;
		int  ll;
	};

	Array<Item>    item;
	Vector<Line>   line;
	
	int            subCnt;//Number of Columns,by Ulti
	int            Width;
	Vector<int>     subWidth;//Column width array,by Ulti
	String         Title;
	Array<String>  subTitle;//Column head text array,by Ulti
	
	int            rowHeight;//Height of a Row,by Ulti
	int            dragPtx;//dragging point,by Ulti
	int            dragCol;
	bool           isdrag;//is dragging or not,by Ulti
	int            cursor;
	int            freelist;
	int            levelcx;

	bool           dirty;
	bool           multiselect;
	bool           isselection;
	
	ScrollBars     sb;
	Scroller       scroller;
	Display        *display;


	void   Dirty(int id = 0);

	void   ReLine(int, int);
	void   SyncTree();
	void   RemoveSubtree(int id);
	void   Scroll();
	int    FindLine(int y) const;
	int    FirstCol();
	int    Right();
	void   RefreshLine(int i);
	void   RefreshItem(int id);
	void   SetCursorLineSync(int i);
	void   SetCursorLine(int i, bool scroll);
	void   SetCursor(int id, bool scroll);

	bool   Tab(int d);
    bool   IsFreeItem(int id);
	void   GatherOpened(int id, Vector<int>& o);
	void   UpdateSelect();
	void   ClearSelTree(int id);
	bool   UpdateSelTree(int id);
	void   ShiftSelect(int l1, int l2);
	bool   ShowDragArrow(Point p);
	void   SetSBSize();
    int    RMargin;
public:
	Callback1<int>  WhenOpen;
	Callback1<int>  WhenClose;
	Callback        WhenCursor;
	Callback        WhenLeftDouble;
	Callback1<Bar&> WhenBar;
	Callback        WhenSelection;
    

	int    Insert(int parent, int i, const Node& n);
	int    Insert(int parent, int i);
	int    Insert(int parent, int i, const Image& img,const Image& hotimg,Value value, bool withopen = false);
	int    Insert(int parent, int i, const Image& img,const Image& hotimg, Value key, Value value, bool withopen = false);

	int    Add(int parent, const Node& n);
	int    Add(int parent);
	int    Add(int parent, const Image& img,const Image& hotimg, Value value, bool withopen = false);
	int    Add(int parent, const Image& img,const Image& hotimg, Value key, Value value, bool withopen = false);

	void   Remove(int id);
	void   RemoveChildren(int id);

	int    GetChildCount(int id) const                         { return item[id].child.GetCount(); }
	int    GetChild(int id, int i) const                       { return item[id].child[i]; }
	int    GetParent(int id) const                             { return item[id].parent; }

	Value  Get(int id) const;//Get返回的是KEY
	Value  GetValue(int id) const;//GetValue才返回值
	Value  operator[](int id) const                            { return Get(id); }
	void   Set(int id, Value value);
	void   Set(int id, Value key, Value value);




   
	Node   GetNode(int id) const                              { return  item[id]; }
	void   SetNode(int id, const Node& n);

	bool   IsOpen(int id) const;
	void   Open(int id, bool open = true);
	void   Close(int id)                                       { Open(id, false); }

	void   OpenDeep(int id, bool open = true);
	void   CloseDeep(int id)                                   { OpenDeep(id, false); }

	void   MakeVisible(int id);

	void   SetCursorLine(int i);
	int    GetCursorLine() const                               { return cursor; }
	void   KillCursor();
	void   SetCursor(int id);
	int    GetCursor() const;
	bool   IsCursor() const                                    { return GetCursor() >= 0; }
    int    GetLevel(int id);
	Point  GetScroll() const;
	void   ScrollTo(Point sc);

	Value  Get() const;
	Value  GetValue() const;

	int    Find(Value key);
	bool   FindSetCursor(Value key);


	void   Clear();

	bool   IsSelection() const            { return isselection; }
	void   ClearSelection();
	void   SelectOne(int id, bool sel,bool multi=false);
	bool   IsSelected(int id) const       { return item[id].sel; }
    int    GetSumWidth();
    int    GetSumWidth(int sub);
  
     
    void   SetSubCount(int cnt);
    void   SetWidth(int width) {  if(width<=0) return; Width=width;SetSBSize();}
    void   SetSubWidth(int sub,int width);
    void   SetTitle(String title){Title=title;}
    void   SetSubTitle(int sub,String title);
    void   SetSubText(int id,int sub,String txt);
	void   Dump();


	UTLCtrl& MultiSelect(bool b = true) { multiselect = true; return *this; }

	typedef UTLCtrl CLASSNAME;

	UTLCtrl();
	~UTLCtrl();
};
