//#ifndef _OPath_Database_h
//#define _OPath_Database_h

#include "Database.h"

UDB::UDB()
{
   dbIsAlive=false;
}

bool UDB::OpenDatabase(String dbfile)
{
	 try
	 {
	    data.Open(dbfile);
	    dbIsAlive=true;
	 }
	 catch(USQLite3Exception &e)
	 {
	    return false;
	 }
	 return true;
}

void UDB::CloseDatabase()
{
	data.Close();
	dbIsAlive=false;
}

bool UDB::AutoTrigger()
{
   if(!dbIsAlive) return false;
   String sql,itrigger,utrigger,dtrigger,val;
   USQLite3Table tab1,tab2;	
   try
   {
    data.ExeDML("begin;");
	tab1=data.GetTable("select name from sqlite_master where type=\'table\'");
    
	for(int row=0;row<tab1.numRows();row++)
	{
		tab1.setRow(row);
		sql=tab1.fieldValue(0);
		if(sql=="DmlLog") continue;
	
		/*itrigger="drop trigger i"+sql+";";
		utrigger="drop trigger u"+sql+";";
		dtrigger="drop trigger d"+sql+";";
		data.ExeDML(itrigger);
		data.ExeDML(utrigger);
		data.ExeDML(dtrigger);*/
	    
		itrigger="create trigger i"+sql+" after insert on "+sql+" begin insert into DmlLog values(null,\'insert into "+sql+" values(\'||new.RowId";
		utrigger="create trigger u"+sql+" after update on "+sql+" begin insert into DmlLog values(null,\'update "+sql+" set ";
		dtrigger="create trigger d"+sql+" before delete on "+sql+" begin insert into DmlLog values(null,\'delete from "+sql+" where RowId=\'||old.RowId);end;";
		sql="PRAGMA table_info("+sql+")";
		tab2=data.GetTable(sql);
		for(int col=1;col<tab2.numRows();col++)
		{
		  tab2.setRow(col);
		  val=tab2.fieldValue(1);
		  itrigger=itrigger+"||\',\'||quote(new."+val+")";
		  utrigger=utrigger+val+"=\'||quote(new."+val+")||\'"+((col==tab2.numRows()-1)?" ":",");
		}
		itrigger+="||\')\');end;"; 
		utrigger+=" where RowId=\'||new.RowId);end;";
		data.ExeDML(itrigger);
		//PromptOK(trigger);
		data.ExeDML(utrigger);
		data.ExeDML(dtrigger);		
		tab2.finalize();
	}
	tab1.finalize();
	data.ExeDML("commit;");
   }
   catch(USQLite3Exception &e)
   {
	   PromptOK(e.errorMessage());
	   tab1.finalize();
	   tab2.finalize();
	   data.ExeDML("rollback;");	   
	   return false;   
   }
}

void UDB::MigrateDb()
{
   if(!dbIsAlive) return;
   USQLite3Table tab;
   String sql,tmp;
   try
   {
	 data.ExeDML("begin;");
	/* 
  //更新Link表 
    //1.从原表中移植数据
	 data.ExeDML("delete from Link;");
	 tab=data.GetTable("select LI_RIID,LI_CHQTY,LI_RICOL,LI_NAME,LI_ANEID,LI_ZNEID,LI_APOID,LI_ZPOID,LI_ID from tLINK;");
	 for(int row=0;row<tab.numRows();row++)
	 {
	    tab.setRow(row);
	    sql="insert into Link(liSyId,liChQty,liSyCol,liName,liAElId,liZElId,liAPoID,liZPoId,LI_ID) VALUES("; 
	    tmp="select syId from System where RI_ID=";
	    if(tab.fieldValue(0)!="0")
	    {
	       sql+=AsString(data.ExeScalar(tmp+tab.fieldValue(0)));
	    }
	    else
	    {
	        sql+='0';
	    }
	    sql=sql+','+tab.fieldValue(1)+','+tab.fieldValue(2)+",\'"+tab.fieldValue(3);
	    
	    tmp="select ElId from Element where EQ_ID=";
	    sql=sql+"\',"+AsString(data.ExeScalar(tmp+tab.fieldValue(4)));
        sql=sql+','+AsString(data.ExeScalar(tmp+tab.fieldValue(5)));

	    tmp="select poId from Port where PO_ID=";
	    sql=sql+','+AsString(data.ExeScalar(tmp+tab.fieldValue(6)));
	    sql=sql+','+AsString(data.ExeScalar(tmp+tab.fieldValue(7)));
	    sql=sql+','+tab.fieldValue(8)+");";
	   	data.ExeDML(sql);      
	 }
     tab.finalize();
     
     //2.更新Port表中LiId
     tab=data.GetTable("select poId,poLiId from Port where poLiId>0;");
	 for(int row=0;row<tab.numRows();row++)
	 {
	   tab.setRow(row);
	   tmp="select liId from Link where LI_ID=";
	   sql="update Port set poLiId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where poId="+tab.fieldValue(0);
	   data.ExeDML(sql);  
	 }
     tab.finalize();
    
  //更新Channel 
     //1.首先从原表移植数据(可手工)
     data.ExeDML("delete from Channel;");
     data.ExeDML("insert into Channel(chLiId,chRow,chHpId,chAChId,chZChId,HI_ID)\
                  select liId,HI_ROW,HI_HPID,HI_AHIID,HI_ZHIID,HI_ID\
                  from   HICH,Link\
                  where  HI_LIID=LI_ID;");
     //2.更新Channel中的各字段
      tab=data.GetTable("select chId,chAChId from Channel where chAChId!=0 and chAChId!=-1;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select chId from Channel where HI_ID=";  
        sql="update Channel set chAChId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where chId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select chId,chZChId from Channel where chZChId!=0 and chZChId!=-1;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select chId from Channel where HI_ID=";  
        sql="update Channel set chZChId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where chId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }                  
      tab.finalize(); 
      
   //更新HPath
      data.ExeDML("delete from HPath;");
      data.ExeDML("insert into Hpath(hpName,hpAHpId,hpZHpId,hpAPoId,hpZPoId,hpAChId,hpZChId,hpAElId,hpZElId,hpIsVc,hpVQty,hpVId0,hpVIdx,hpRoute,hpUsed,HP_ID)\
                   select HP_NAME,HP_AHPID,HP_ZHPID,HP_APOID,HP_ZPOID,HP_AHIID,HP_ZHIID,HP_ANEID,HP_ZNEID,HP_ISVCG,HP_VQTY,HP_VPID,HP_VINDX,HP_RT,HP_USED,HP_ID\
                   from tHPATH;"); 
       //APoId,ZPoId                     
      tab=data.GetTable("select hpId,hpAPoId from HPath where hpAPoId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select poId from Port where PO_ID=";  
        sql="update HPath set hpAPoId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select hpId,hpZPoId from HPath where hpZPoId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select poId from Port where PO_ID=";  
        sql="update HPath set hpZPoId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
	  //AChId,ZChId
      tab=data.GetTable("select hpId,hpAChId from HPath where hpAChId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select chId from Channel where HI_ID=";  
        sql="update HPath set hpAChId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select hpId,hpZChId from HPath where hpZChId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select chId from Channel where HI_ID=";  
        sql="update HPath set hpZChId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();	  
	  //AElId,ZElId
      tab=data.GetTable("select hpId,hpAElId from HPath where hpAElId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select elId from Element where EQ_ID=";  
        sql="update HPath set hpAElId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select hpId,hpZElId from HPath where hpZElId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select elId from Element where EQ_ID=";  
        sql="update HPath set hpZElId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();	       
      //hpVId0
      tab=data.GetTable("select hpId,hpVId0 from HPath where hpVId0!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select hpId from HPath where HP_ID=";  
        sql="update HPath set hpVId0="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where hpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
	  
  //更新TimeSlot 
     //1.首先从原表移植数据(可手工)
     data.ExeDML("delete from TimeSlot;");
     data.ExeDML("insert into TimeSlot(tsHpId,tsRow,tsLpId,tsATsId,tsZTsId,LO_ID)\
                  select hpId,LO_ROW,LO_LPID,LO_ALOID,LO_ZLOID,LO_ID\
                  from   tLOCH,HPath\
                  where  LO_HPID=HP_ID;");
     //2.更新TimeSlot中的各字段
      tab=data.GetTable("select tsId,tsATsId from TimeSlot where tsATsId!=0 and tsATsId!=-1;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select tsId from TimeSlot where LO_ID=";  
        sql="update TimeSlot set tsATsId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where tsId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select tsId,tsZTsId from TimeSlot where tsZTsId!=0 and tsZTsId!=-1;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select tsId from TimeSlot where LO_ID=";  
        sql="update TimeSlot set tsZTsId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where tsId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize(); 
	  
  //更新LPath
      data.ExeDML("delete from LPath;");
      data.ExeDML("insert into LPath(lpALpId,lpZLpId,lpAPoId,lpZPoId,lpATsId,lpZTsId,lpAElId,lpZElId,lpIsVc,LP_ID)\
                   select LP_ALPID,LP_ZLPID,LP_APOID,LP_ZPOID,LP_ALOID,LP_ZLOID,LP_ANEID,LP_ZNEID,LP_ISVCG,LP_ID \
                   from tLPATH;"); 
       //APoId,ZPoId                     
      tab=data.GetTable("select LpId,LpAPoId from LPath where lpAPoId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select poId from Port where PO_ID=";  
        sql="update LPath set lpAPoId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where lpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select lpId,lpZPoId from LPath where lpZPoId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select poId from Port where PO_ID=";  
        sql="update LPath set lpZPoId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where lpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
	  //ATsId,ZTsId
      tab=data.GetTable("select lpId,lpATsId from LPath where lpATsId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select tsId from TimeSlot where LO_ID=";  
        sql="update LPath set lpATsId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where lpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select lpId,lpZTsId from LPath where lpZTsId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select tsId from TimeSlot where LO_ID=";  
        sql="update LPath set lpZTsId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where lpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();	  
	  //AElId,ZElId
      tab=data.GetTable("select lpId,lpAElId from LPath where lpAElId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select elId from Element where EQ_ID=";  
        sql="update LPath set lpAElId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where lpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select lpId,lpZElId from LPath where LpZElId!=0;");              
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select elId from Element where EQ_ID=";  
        sql="update LPath set lpZElId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where lpId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();  
	       
  //更新Channel 中的chHpId     
      tab=data.GetTable("select chId,chHpId from Channel where chHpId>0;"); 
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select hpId from HPath where HP_ID=";  
        sql="update Channel set chHpId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where chId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();      

  //更新TimeSlot 中的tsLpId     
      tab=data.GetTable("select tsId,tsLpId from TimeSlot where tsLpId>0;"); 
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select lpId from LPath where LP_ID=";  
        sql="update TimeSlot set tsLpId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where tsId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();	  

  //更新Port 中的poHLPaId     
      tab=data.GetTable("select poId,poHLPaId from Port where poHLPaId>0 and poCpNum=2;"); 
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select lpId from LPath where LP_ID=";  
        sql="update Port set poHLPaId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where poId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
      tab=data.GetTable("select poId,poHLPaId from Port where poHLPaId>0 and poCpNum>2;"); 
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        tmp="select hpId from HPath where HP_ID=";  
        sql="update Port set poHLPaId="+AsString(data.ExeScalar(tmp+tab.fieldValue(1)))+" where poId="+tab.fieldValue(0);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();
	  
      tab=data.GetTable("select caId,SL_ID from Card,tSLOT where caName=SL_CARD;"); 
	  for(int row=0;row<tab.numRows();row++)
	  {                  
        tab.setRow(row);
        sql="update Slot set slCaId="+tab.fieldValue(0)+" where SL_ID="+tab.fieldValue(1);  
        data.ExeDML(sql);     
	  }
	  tab.finalize();*/
     
      data.ExeDML("commit;");
   }
   catch(USQLite3Exception &e)
   {
	   PromptOK(e.errorMessage());	   
	   return;   
   }	 
}



//#endif
