#include <CtrlLib/CtrlLib.h>
#include <UVarCtrl/UTLCtrl.h>
#include <UVarCtrl/UTCtrl.h>
#include "LeftCtrl.h"


/*#define IMAGECLASS OPathImg
#define IMAGEFILE <OPath/OPath.iml>
#include <Draw/iml.h>*/


//#include "OPath.rc"

    
struct App : public TopWindow
{
	ULeftCtrl  Left;
	URightCtrl Right;

	Splitter  h;
	MenuBar menu;
	ToolBar    toolbar;
	StatusBar  statusbar;

	void MainBar(Bar& bar);
    bool menu_enabled;
    void login();
	void Enable()
	{
		menu_enabled = !menu_enabled;
	}

	void ShowNumber(int n)
	{
		PromptOK(AsString(n));
	}

	void SubMenu(Bar& bar)
	{
		for(int i = 0; i < 10; i++)
			bar.Add(AsString(i), THISBACK1(ShowNumber, i));
	}

	void Menu(Bar& bar)
	{
		bar.Add(t_("登陆"), THISBACK(login))
		   .Check(menu_enabled);
		bar.Add(menu_enabled,"自动创建触发器",THISBACK(autotrigger));
		bar.Add(menu_enabled,"升级数据库",THISBACK(MigrateDB));
		bar.Add("退出", THISBACK(Exit))
		   .Key(K_CTRL_E);
	}
	
	void autotrigger();
	void MigrateDB();
	
	void Exit()
	{
		if(!menu_enabled)db.CloseDatabase();
		Close();
	}	
	void MainTool(Bar& bar)
	{
	   bar.Add("Connect Database", CtrlImg::new_doc(), THISBACK(login))
	          .Key(K_CTRL_N)
	          .Help("Open new window");
	}
	//void New(){}	
	typedef App CLASSNAME;
	App();
};


void App::MainBar(Bar& bar)
{
  bar.Add(t_("系统"),THISBACK(Menu));
}

void App::login()
{
  menu_enabled = !menu_enabled;
  if(menu_enabled)
  {
     if(!db.OpenDatabase("d:/data/data.db3")) PromptOK("Can't Open!");
     if(!Left.LoadTree()) return;
  }
  else 
  {
     db.CloseDatabase();
     Left.RootTree();
     Right.Close();
  }
}

void App::autotrigger()
{
	db.AutoTrigger();
}

void App::MigrateDB()
{
	db.MigrateDb();
}
App::App()
{
	h.Horz(Left,Right);
	Left.right=&Right;
	//v << c<< b << d;
	//v.Vert();
	
	h.BarWidth(8);
	Add(h.SizePos());
	h.SetPos(2000,0);
	h.SetFrame(ViewFrame());
	Sizeable().Zoomable();
    Maximize();
    
    Title("OPath");
   
    AddFrame(menu);
	AddFrame(TopSeparatorFrame());
	AddFrame(toolbar);
	AddFrame(statusbar);
    menu_enabled = false;
    menu.Set(THISBACK(MainBar));
    Icon(OPathImg::AppIcon(),OPathImg::AppIcon32());
    //Icon(Image::Icon(5555, true), Image::Icon(5555, false));
    toolbar.Set(THISBACK(MainTool));
    //BackPaint();//添加BackPaint()后可避免闪烁,添加到自绘的地方去
    //Right.OpenDatabase("d:/data/NetPath.db3","d:/data/logdml.db3");
}


GUI_APP_MAIN
{
	SetDefaultCharset(CHARSET_UTF8); 
	//App thisApp;
	
	//thisApp.Icon(OPathImg::AppIcon(),OPathImg::AppIcon32());
	//thisApp.Run();
	App().Run();
}

