#include <Core/Core.h>

using namespace Upp;

#ifdef PLATFORM_WIN32
	#include <CtrlCore/CtrlCore.h>
	#define DEFAULT_METHOD "MINGW"
	#define execv _execv
	#define _MAIN GUI_APP_MAIN
#elif PLATFORM_LINUX
	#define DEFAULT_METHOD "GCC"
	#define _MAIN CONSOLE_APP_MAIN
#endif

void Launch(const char* root){
	char app[512];
	strcpy(app,root);

	Vector<const char*> args;
	args.Add("theide");
#ifdef PLATFORM_LINUX
	strcat(app,"upp/theide/lib/theide");
	
	char bin[512];
	strcpy(bin,root);
	strcat(bin,"upp/theide/theide");
	args.Add(bin);
	
	char var1[512], var2[512];
	sprintf(var1,"%supp/theide/lib",root);
	sprintf(var2,"%supp/",root);
	//DUMP(var1);
	//DUMP(var2);
	setenv("LD_LIBRARY_PATH",var1,1);
	setenv("UPP_HOME",var2,1);
#elif defined(PLATFORM_WIN32)
	strcat(app,"upp\\theide\\umk.exe");
	args.Add("theide.exe");
#endif
	//DUMP(app);
	//DUMP(FileExists(app));
	Vector<String>const & cmd=CommandLine();
	for(int i=0;i<cmd.GetCount();i++){
		args.Add(cmd[i]);
	}
	//DUMPC(args);
	args.Add(NULL);
	execv(app,(char*const*)args.Begin());
	LOG("execv failed, errno = " << errno << " : " << strerror(errno) );
}

void FindAllFiles(Vector<String>& list,String dir,const char* mask){
	FindFile ff(AppendFileName(dir,mask));
	while(ff){
		list.Add(AppendFileName(dir,ff.GetName()));
		ff.Next();
	}
}

String AsCStringPart(const String& s){
	String str=AsCString(s);
	if(str[0]=='"')	str=str.Mid(1,str.GetCount()-2);
	return str;
}

_MAIN{
	String root=GetExeDirFile("");
	String bin=AppendFileName(root,"upp/theide");
	String last=LoadFile(AppendFileName(bin,"last.cfg"));
	if(last!=root)
	{
		String lastC=AsCStringPart(last);
		String rootC=AsCStringPart(root);
		Vector<String> list;
		FindAllFiles(list,bin,"*.var");
		FindAllFiles(list,bin,"*.bm");
		for(int i=0;i<list.GetCount();i++){
			String s=LoadFile(list[i]);
			s.Replace(lastC,rootC);
			s.Replace(last,root);
			SaveFile(list[i],s);
		}
		SaveFile(AppendFileName(bin,"last.cfg"),root);
	}
	SaveFile(AppendFileName(bin,"default_method"),DEFAULT_METHOD);
	Launch(root);
}
