#ifndef _guitest_Grid_h_
#define _guitest_Grid_h_

#include <CtrlLib/CtrlLib.h>

NAMESPACE_UPP;

class Grid:public Ctrl{
	int sx,sy;
	Color c;
	Array<ParentCtrl> p;
	bool grid;
public:
	Grid();
	Grid(int x,int y);
	
	Grid& SetSize(int x,int y);
	Grid& SetXSize(int x)         {SetSize(x,sy); return *this;}
	Grid& SetYSize(int y)         {SetSize(sx,y); return *this;}
	Grid& SetColor(class Color color)  {c=color; Refresh(); return *this;}
	Grid& ShowGrid(bool show=true);
	Grid& NoGrid()               {return ShowGrid(false);}
	
	ParentCtrl& Get(int x,int y);
	
	virtual void Paint(Draw& w);
	virtual void Layout();
	
	class GridLine{
		int x; Grid& g;
		friend class Grid;
		GridLine(int x,Grid& g):x(x),g(g){};
	public:
		ParentCtrl& operator[](int y) {return g.Get(x,y);};
	};

	GridLine operator[](int x){return GridLine(x,*this);}
};

END_UPP_NAMESPACE;

#endif
