#include "Grid.h"

NAMESPACE_UPP;

Grid::Grid():grid(false){
	c=Black();
	Transparent();
	SetSize(1,1);
}

Grid::Grid(int x,int y):grid(false){
	c=Black();
	Transparent();
	SetSize(x,y);
}

Grid& Grid::SetSize(int x,int y){
	if(x>0&&y>0){
		sx=x;
		sy=y;
		p.Clear();
		p.SetCount(x*y);
		for(int i = 0; i < p.GetCount(); i++)
			Add(p[i]);
		Layout();
		Refresh();
	}
	return *this;
}

Grid& Grid::ShowGrid(bool show){
	grid=show;
	Layout();
	Refresh();
	return *this;
}

ParentCtrl& Grid::Get(int x,int y){
	ASSERT(x>=0 && y>=0 && x<sx && y<sy);
	return p[x+sx*y];
}

void Grid::Paint(Draw& w){
	if(!grid) return;
	Size sz=GetSize();
	int cx=(sz.cx-sx-1)/sx;
	int cy=(sz.cy-sy-1)/sy;
	for(int i = 0; i <= sx; i++)
		w.DrawLine(i*(1+cx),0,i*(1+cx),sy*(cy+1),0,c);
	for(int j = 0; j <= sy; j++)
		w.DrawLine(0,j*(1+cy),sx*(cx+1),j*(1+cy),0,c);
}

void Grid::Layout(){
	if(sx<=0||sy<=0) return;
	int s=grid?1:0;
	Size sz=GetSize();
	int cx=(sz.cx-s*sx-s)/sx;
	int cy=(sz.cy-s*sy-s)/sy;
	for(int i = 0; i < sx; i++)
		for(int j = 0; j < sy; j++){
			p[i+sx*j].LeftPos(i*(s+cx)+s,cx).TopPos(j*(s+cy)+s,cy);
		}
}

END_UPP_NAMESPACE;