#include "GridCtrlMultiSortResetErr.h"

Id col1("cola");
Id col2("colb");

GridCtrlMultiSortResetErr::GridCtrlMultiSortResetErr()
{
	typedef GridCtrlMultiSortResetErr CLASSNAME;
	CtrlLayout(*this, "Window title");
	maingrid.AddColumn(col1, "column 1", 100);
	maingrid.AddColumn(col2, "column 2", 100);
	maingrid.MultiSorting(true);
	maingrid.Add("Test val 1a", "Test value 1b");
	btnResetAfterSortCol <<= THISBACK(ResetAfterSortCol);
}

void GridCtrlMultiSortResetErr::ResetAfterSortCol() {
	maingrid.Reset(); // Crashes here if user has sorted any column
	maingrid.Ready(false);
	maingrid.AddColumn(col1, "column 1", 100);
	maingrid.AddColumn(col2, "column 2", 100);
	maingrid.MultiSorting(true);
	maingrid.Add("Test val 1a", "Test value 1b");
	maingrid.Ready(true);
}

GUI_APP_MAIN
{
	GridCtrlMultiSortResetErr().Run();
}

/*

Steps to recreate crash:
Run program.  Then click on any column header to request a sort.  The code enters 
function "void GridCtrl::LeftUp(Point p, dword keyflags)" in GridCtrl.cpp.  j is calculated at line 2181 in 
"j = GetMouseCol(leftpnt, true, false)". j is a value of 1, which is incorrect since there is no fixed_cols.
Then it takes the "else" branch point at line 2225 of "if(j >= fixed_cols && i == 0 && hitems[i].sortable)"
This is because I'm setting the first sort column of a multicolumn sort.
Then, at 2235, the code "hitems[j].sortcol = 1;" sets item #1 to a 1.  I think this means that "column 1 is the first column in the sort order".
At line 2242 is the exposure point: "sortOrder.Add(newSortCol);" adds a one.

I'm guessing both the hitems index and the column index are exhibiting a one-off issue.

Crashpoint:
When I send "maingrid.Reset()", I end up in the code in GridSort.cpp at function "void GridCtrl::ClearMultisort(int n)" line 122.
n is zero at this point.

At line 126, "int c = GetIdCol(sortOrder[i], true);" tries to reference an i of zero, which has not been set and c becomes -1, which creates an out of range error.


*/