#ifndef _Reports3_RepGen_h_ 
#define _Reports3_RepGen_h_

#include "MyReport.h"

using namespace Upp;

class RepGen  
{
private:
	String 					tplHeader, tplBody, tplFooter;
	String					tplb, tplbr;
	String 					resultb;
	bool 						ENDCALCULATE;
	bool 						IN_BP_LOOP;
	XmlNode					rep;
	PageSettings		ps;
	bool						tOpened;
	
	void PCRE_Replace(String& where, String s_from, String s_to);
	
public:
	
	bool SetTemplate(String fn);
	
	Callback RepGenReportStart;
	Callback RepGenReportVar;
	Callback RepGenReportFinish;
	Callback RepGenCalculateStart;
	Callback RepGenCalculateBody;
	Callback RepGenCalculateFinish;

	void SubstVarH(String s_from, String s_to) 
	{
		PCRE_Replace(tplHeader, s_from, s_to);
	};

	void SubstVarB(String s_from, String s_to) 
	{
		if (!IN_BP_LOOP)
			PCRE_Replace(tplBody, s_from, s_to);
		else
			PCRE_Replace(tplbr, s_from, s_to);
	};

	void SubstVarF(String s_from, String s_to) 
	{
		PCRE_Replace(tplFooter, s_from, s_to);
	};
	
	void PlaceImageH(String s_from, Image im_to, Size rep_place = Size(0,0));
	void PlaceImageB(String s_from, Image im_to, Size rep_place = Size(0,0));
	void PlaceImageF(String s_from, Image im_to, Size rep_place = Size(0,0));
	String PlaceImage(String s_from, Image im_to, Size rep_place = Size(0,0));
	
	void LoopDone(bool indicator = true) { ENDCALCULATE = indicator; };
	void Perform();

	typedef RepGen CLASSNAME;
	
	RepGen() { tOpened = false; };	
};

#endif
