#ifndef _Report_Report_h
#define _Report_Report_h

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include <RichText/RichText.h>
#include <PdfDraw/PdfDraw.h>

using namespace Upp;

#define  LAYOUTFILE <MyReport/Report.lay>
#include <CtrlCore/lay.h>

class PageSettings : Moveable<PageSettings>
{
public:
	String	format;
  int 		oSize;
  int 		vSize;
  int 		tMarg;
  int 		lMarg;
  int 		bMarg;
  int 		rMarg;
  int			hSize;
  int			fSize;
  
  typedef PageSettings CLASSNAME;
  
  PageSettings(String f = "", int os = 0, int vs = 0, int tm = 0, int lm = 0, int bm = 0, int rm = 0, int hs = 0, int fs = 0)
  	{ format = f; oSize = os; vSize = vs; tMarg = tm; lMarg = lm; bMarg = bm; rMarg = rm; hSize = hs; fSize = fs; }
};

class Margins : Moveable<Margins>
{
public:
	int tMarg, bMarg, rMarg, lMarg;
	
	typedef Margins CLASSNAME;	
	
	Margins() 																{ tMarg = bMarg = rMarg = lMarg = 0; }
	Margins(int tm, int lm, int bm, int rm) 	{ tMarg =  tm; bMarg = bm; rMarg = rm; lMarg = lm; }
};

class ReportSource : Moveable<ReportSource>
{
private:  
	PageSettings			ps;
	
	String						header;
	String						body;
	String						footer;

public:

	ReportSource& 		Set(PageSettings& a, String& h, String& b, String& f) 	{ ps = a; header = h; body = b; footer = f; return *this; }
	PageSettings 			GetPs() 																								{ return ps; }
	String						GetHeader()																							{ return header; }
	String						GetBody()																								{ return body; }
	String						GetFooter()																							{ return footer; }
	
	typedef ReportSource CLASSNAME;
	
	ReportSource() { }
  
};

#include <MyReport/MyRepGen.h>

class Report : public DrawingDraw, public PageDraw 
{
public:
	virtual Draw& Info();
	virtual Draw& Page(int i);

private:
	Array<Drawing> 	page;
	int            	pagei;
	int            	y;
	String         	header, footer;
	int            	headercy, headerspc, footercy, footerspc;

	void    Flush();
	String  FormatHF(const char *s, int pageno);
	int     GetHeightHF(const char *s);
	void    PaintHF(Draw& w, int y, const char *qtf, int i);
	void    StartPage(int i);
	void    RestartPage();

public:
	int                   GetCount()                  { Flush(); return page.GetCount(); }
	Drawing               GetPage(int i)              { Flush(); return page[i]; }
	Drawing               operator[](int i)           { return GetPage(i); }
	const Array<Drawing>& GetPages()                  { Flush(); return page; }
	Margins								dwgmarg;
	ReportSource					rs;

	void                  Clear();
	
	Rect                  GetPageRect();

	void                  SetY(int _y)                { y = _y; }
	int                   GetY() const                { return y; }
	
	void                  NewPage()                   { Page(pagei + 1); }
	
	void                  Put(const RichText& txt);
	void                  Put(const char *qtf);
	Report&               operator<<(const char *qtf) { Put(qtf); return *this; }

	Report&               SetPageSize(Size sz, Margins ma);
	Report&               Landscape();
	Report&               Header(const char *qtf, int spc = 150);
	Report&               Footer(const char *qtf, int spc = 150);
	Report&               NoHeader()                  { return Header(NULL, 0); }
	Report&               NoFooter()                  { return Footer(NULL, 0); }
	
	Report&								SetSource(PageSettings& a, String& h, String& b, String& f);
	
	Report();
	Report(const Size &sz, const Margins &ma);
};

class ReportView : public Ctrl {
public:
	virtual void Paint(Draw& w);
	virtual void Layout();
	virtual bool Key(dword key, int);
	virtual void LeftDown(Point p, dword);
	virtual void MouseWheel(Point, int zdelta, dword);

protected:
	ScrollBar sb;
	Report   *report;
	Image     page[64];
	int       pagei[64];
	Size      pagesize;
	int       vsize;

	int       pm;
	int       pvn;
	bool      numbers;
	int       pages;

	Image     GetPage(int i);

	void      Init();
	void      Sb();
	void      Numbers()               { Refresh(); }
	Size      GetReportSize();

public:
	Callback  WhenGoPage;

	enum Pages {
		PG1, PG2, PG4, PG16
	};
	ReportView& Pages(int pags)       { pages = pags; Layout(); return *this; }
	ReportView& Numbers(bool nums)    { numbers = nums; Refresh(); return *this; }

	void      Set(Report& report);
	int       GetFirst() const        { return sb / pagesize.cy * pvn; }

	void      ScrollInto(int toppage, int top, int bottompage, int bottom);

	typedef ReportView CLASSNAME;

	ReportView();
};

class ReportWindow : public WithReportWindowLayout<TopWindow> 
{
	void Pages()   { pg.Pages(~sw); }
	void Numbers() { pg.Numbers(numbers); }
	void GoPage()  { sw <<= ReportView::PG1; Pages(); }
	void Pdf();
	void Save();

	Array<Button>         button;
	Report               *report;

public:
	ReportView pg;

	typedef ReportWindow CLASSNAME;

	static void SetPdfRoutine(String (*pdf)(const Report& report, int margin));

	void SetButton(int i, const char *label, int id);

	int  Perform(Report& report, int zoom = 100, const char *caption = t_("Report"), const String &fn = "");
	//int  Perform(Report& report, int zoom = 100, const char *caption = t_("Report"));

	ReportWindow();
};

bool   Print(Report& r, int i, const char *name);
bool   RepPerform(Report& r, const char *name, const String &fn);

String MyRepToPdf(Report& report);
int MMsToPoints(int m);

#endif
