#include <plugin/pcre/Pcre.h>
#include <plugin/pcre/lib/pcre.h>

#include <MyReport/MyReport.h>

static Array<QtfRichObject> qtfim;

class RepGenReportWindow : public ReportWindow 
{
public:
	typedef RepGenReportWindow CLASSNAME;

	RepGenReportWindow() 
	{
		ReportWindow::ReportWindow();
	};
};

bool RepGen::SetTemplate(String fn)
{
  if(FileExists(fn))
  {
	  rep = ParseXML(LoadFile(fn));
	  if((String)rep.GetAdd("info").Attr("fileType") != "QTF report")
	  {
	    return false;
	  }
	
	  ps.format = rep.GetAdd("page").Attr("format");
	  ps.oSize = ScanInt(rep.GetAdd("page").Attr("oSize"));
	  ps.vSize = ScanInt(rep.GetAdd("page").Attr("vSize"));
	  ps.tMarg = ScanInt(rep.GetAdd("page").Attr("tMarg"));
	  ps.lMarg = ScanInt(rep.GetAdd("page").Attr("lMarg"));
	  ps.bMarg = ScanInt(rep.GetAdd("page").Attr("bMarg"));
	  ps.rMarg = ScanInt(rep.GetAdd("page").Attr("rMarg"));
	  ps.hSize = ScanInt(rep.GetAdd("page").Attr("hSize"));
	  ps.fSize = ScanInt(rep.GetAdd("page").Attr("fSize"));
	
	  tplHeader = Join(Split(rep.GetAdd("header").At(0).GetText(), '\n'), "");
	  tplBody = Join(Split(rep.GetAdd("body").At(0).GetText(), '\n'), "");
	  tplFooter = Join(Split(rep.GetAdd("footer").At(0).GetText(), '\n'), "");
	  
	  tOpened = true;
	  
	  return true;
  }
  else return false;
}

void RepGen::PCRE_Replace(String& where, String s_from, String s_to) 
{
	RegExp r0("(.*)" + s_from + "(.*)", RegExp::MULTILINE);
	while (r0.GlobalMatch(where)) 
	{
		if(r0.GetCount() == 2) 
		{		  
			where = r0[0] + s_to + r0[1];
		}
	}
};

void RepGen::PlaceImageH(String s_from, Image im_to, Size rep_place )
{
  String r = PlaceImage(s_from, im_to, rep_place);
  SubstVarH(s_from, r);
  return;
}

void RepGen::PlaceImageB(String s_from, Image im_to, Size rep_place )
{
  String r = PlaceImage(s_from, im_to, rep_place);
  SubstVarB(s_from, r);
  return;  
}

void RepGen::PlaceImageF(String s_from, Image im_to, Size rep_place )
{
  String r = PlaceImage(s_from, im_to, rep_place);
  SubstVarF(s_from, r);
  return;  
}

String RepGen::PlaceImage(String s_from, Image im_to, Size rep_place )
{
	String s;
	if(!im_to.IsEmpty()) 
	{
		if(rep_place.cy != 0) 
		{
			if(im_to.GetWidth() * 100 / im_to.GetHeight() > rep_place.cx * 100 / rep_place.cy)
				qtfim.Add(CreatePNGObject(im_to, rep_place.cx, 0));
			else
				qtfim.Add(CreatePNGObject(im_to, 0, rep_place.cy));
		} 
		else 
		{
			qtfim.Add(CreatePNGObject(im_to));
		}
		s << qtfim[qtfim.GetCount() - 1];
		return s;
	} 
	else 
	{
		return "";
	}	
};

void RepGen::Perform()
{
  if(!tOpened) return;
  
	Report r;
	{
		IN_BP_LOOP = false;
		RegExp r_b("(.*)::([^:]*)##BT(.*)##ET([^:}]*)(::|}})(.*)", RegExp::MULTILINE);
		RegExp r_bp("(.*)##BP(.*)##EP(.*)", RegExp::MULTILINE);
		RepGenReportStart.Execute();
		RepGenReportVar.Execute();
		if(RepGenCalculateBody) 
		{
			IN_BP_LOOP = true;
			while (r_b.GlobalMatch(tplBody)) 
			{
				if (r_b.GetCount() == 6) 
				{				  
					tplb = "::" + r_b[1] + r_b[2] + r_b[3];
					resultb = "";
					ENDCALCULATE = false;
					RepGenCalculateStart();
					while (ENDCALCULATE == false) 
					{
						tplbr = tplb;		
						RepGenCalculateBody();
						resultb += tplbr;
					}
					RepGenCalculateFinish();
					tplBody = r_b[0] + resultb + r_b[4] + r_b[5];
				} 
				else tplb = "";
			}
			IN_BP_LOOP = false;
			IN_BP_LOOP = true;
			while (r_bp.GlobalMatch(tplBody)) 
			{
				if (r_bp.GetCount() == 3) 
				{
					tplb = r_bp[1];
					resultb = "";
					ENDCALCULATE = false;
					RepGenCalculateStart();
					while (ENDCALCULATE == false) 
					{
						tplbr = tplb;
						RepGenCalculateBody();
						resultb += tplbr;
					}
					RepGenCalculateFinish.Execute();
					tplBody = r_bp[0] + resultb + r_bp[2];
				} 
				else tplb = "";
			}
		}
		IN_BP_LOOP = false;
		RepGenReportFinish.Execute();

		String headerQtf, footerQtf;				
		RichTextView rv;
		
		rv.SetQTF(tplHeader);
		
		headerQtf = AsQTF(rv.Get(), CHARSET_UTF8, QTF_NOSTYLES|QTF_BODY);
		
		rv.SetQTF(tplFooter);
		footerQtf = AsQTF(rv.Get(), CHARSET_UTF8, QTF_NOSTYLES|QTF_BODY);
		
		r.SetSource(ps, headerQtf, tplBody, footerQtf);
	}
	RepGenReportWindow().Perform(r);
};
