#include "RepDesigner.h"

void RepDesigner::PrgSetup() 
{
	ProgramSetup(0);
	return;
}

void RepDesigner::ProgramSetup(int vTab) 
{
  /* Callbacks */
	fPageSetup.gPageDir <<= THISBACK(RevertOrientation);
	fPageSetup.gDlFormat.WhenAction = THISBACK(ChangePageSize);

	/* Tabs */
	fProgSetup.gTabs.Reset();
	fProgSetup.gTabs.Add(fPageSetup, t_("Page"));
	
	/* Page tab	*/
	fPageSetup.gDlFormat.Clear();
	fPageSetup.gDlFormat.Add("B5", "B5");
	fPageSetup.gDlFormat.Add("A4", "A4");
	fPageSetup.gDlFormat.Add("A3", "A3");
	fPageSetup.gDlFormat = ps.format;
	fPageSetup.gTopMargin.SetData(ps.tMarg);
	fPageSetup.gLeftMargin.SetData(ps.lMarg);
	fPageSetup.gBottomMargin.SetData(ps.bMarg);
	fPageSetup.gRightMargin.SetData(ps.rMarg);
	fPageSetup.gHeaderS.SetData(ps.hSize);
	fPageSetup.gFooterS.SetData(ps.fSize);
	Orientation();

	fProgSetup.gTabs.Set(vTab);
	if(fProgSetup.Execute() == IDOK) 
	{
	  /* Page */
	  ps.format = fPageSetup.gDlFormat.GetKey(fPageSetup.gDlFormat.GetIndex());
		ps.tMarg = (int)fPageSetup.gTopMargin;
		ps.lMarg = (int)fPageSetup.gLeftMargin;
		ps.bMarg = (int)fPageSetup.gBottomMargin;
		ps.rMarg = (int)fPageSetup.gRightMargin;
		ps.hSize = (int)fPageSetup.gHeaderS;
		ps.fSize = (int)fPageSetup.gFooterS;
		AdjPageSize();
		modified = true;
	}
	
	return;	
}

void RepDesigner::Orientation() 
{
  int oSize = ps.oSize;
  int vSize = ps.vSize;
  
  if(vSize > oSize) 
  	fPageSetup.gPageIcon.SetImage(RepDesignerImg::portrait_1_48());
  else
  	fPageSetup.gPageIcon.SetImage(RepDesignerImg::landscape_1_48());
  
 	fPageSetup.gPageDir = (int)(ps.oSize > ps.vSize);

  return;
}

void RepDesigner::RevertOrientation() 
{
  int oSize = ps.oSize;
  int vSize = ps.vSize;
  
	ps.oSize = vSize;
	ps.vSize = oSize;
	
	Orientation();  
  return;
}

void RepDesigner::ChangePageSize() 
{
  if((String)fPageSetup.gDlFormat.GetKey(fPageSetup.gDlFormat.GetIndex()) == "B5")
  {
  	if(fPageSetup.gPageDir == 0)
  	{
  		ps.vSize = 210;
  		ps.oSize = 149;
  	}
  	else
  	{
  		ps.vSize = 149;
  		ps.oSize = 210;  	  
  	}
  }
  else if((String)fPageSetup.gDlFormat.GetKey(fPageSetup.gDlFormat.GetIndex()) == "A4")
  {
  	if(fPageSetup.gPageDir == 0)
  	{
  		ps.vSize = 297;
  		ps.oSize = 210;
  	}
  	else
  	{
  		ps.vSize = 210;
  		ps.oSize = 297;  	  
  	}
  }
  else if((String)fPageSetup.gDlFormat.GetKey(fPageSetup.gDlFormat.GetIndex()) == "A3")
  {
  	if(fPageSetup.gPageDir == 0)
  	{
  		ps.vSize = 420;
  		ps.oSize = 297;
  	}
  	else
  	{
  		ps.vSize = 297;
  		ps.oSize = 420;  	  
  	}
  }
  return;
}
