#ifndef _RepDesigner_RepDesigner_h_
#define _RepDesigner_RepDesigner_h_

#include <CtrlLib/CtrlLib.h>
#include <RichEdit/RichEdit.h>
#include <PdfDraw/PdfDraw.h>
#include <MyReport/MyReport.h>

using namespace Upp;

#define LAYOUTFILE <RepDesigner/RepDesigner.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS RepDesignerImg
#define IMAGEFILE  <RepDesigner/RepDesigner.iml>
#include <Draw/iml_header.h>

class RepDesigner : public TopWindow 
{
public:
  virtual void DragAndDrop(Point, PasteClip& d);
  virtual void FrameDragAndDrop(Point, PasteClip& d);

protected:
  RichEdit   		editor;
  RichEdit   		header;
  RichEdit   		footer;
  MenuBar    		menubar;
  ToolBar    		toolbar;
  StatusBar  		statusbar;
  String     		filename;
  XmlNode		 		rep;
  PageSettings	ps;
  bool					modified;
  Splitter      sf0, sf1;
  
	/* Program setup dialog */
	WithlayProgSetup<TopWindow> 				fProgSetup;
  WithlayPageSetup<ParentCtrl> 				fPageSetup;
  
  static LRUList& lrufile() { static LRUList l; return l; }

	/* RepDesigner.cpp */
  void Load(const String& filename);
  void OpenFile(const String& fn);
  void New();
  void Open();
  void Save0();
  void Save();
  void SaveAs();
  void Print();
  void Pdf();
  void About();
  void Destroy();
  void SetBar();
  void FileBar(Bar& bar);
  void AboutMenu(Bar& bar);
  void MainMenu(Bar& bar);
  void MainBar(Bar& bar);
  void AdjPageSize();
  
 	/* Setup.cpp */
 	void PrgSetup();
 	void ProgramSetup(int vTab=0);
	void Orientation();
	void RevertOrientation();
	void ChangePageSize();
  
public:
  typedef RepDesigner CLASSNAME;

  static void SerializeApp(Stream& s);

  RepDesigner();
};

FileSel& RepDesignerFs();
FileSel& PdfFs();

#endif
