#include "Editor.h"

void FillDropDown(DropList& aDrop, int aStart, int aEnd) {
	aDrop.Add(-1);
	for (int i = 0; i < 149; i++) 
		aDrop.Add(i);
	aDrop.SetDisplay(Single<TileDisplay>());
	aDrop.SetLineCy(32 + 2);
	aDrop.SetIndex(0);
}

Editor::Editor(): edit(-1) {
	Add(animals.SizePos());
	OnEdit(0);
}

void Editor::OnEdit(int aPane) {
	animals.Hide();
	animals.Show();
}

void TileDisplay::Paint(Draw& w, const Rect& r, const Value& q,
	               Color ink, Color paper, dword style) const
{
	int tile = q;
	
	w.DrawRect(r, paper);
	if (tile >= 0) {
		int x = tile % 16;
		int y = tile / 16;
		//w.DrawImage(r.left + 1, r.top + 1, guiTiles, Rect(x * 32, y * 32, x * 32 + 32, y * 32 + 32));
	}
	w.DrawText(r.left + 4 + 32, r.top + 10, IntStr(tile), StdFont(), ink);
}

String DataPath;

GUI_APP_MAIN {
	Editor edit;
	edit.Run();
}