#include "ConsoleCtrl.h"

bool ConsoleCtrl::Key (dword key, int count)
{
	bool b;
	b = LineEdit::Key(key, count); //echo
	b = in.Key(key, count);
	String s = ~in;
	in.Clear();
	if(s.IsEmpty()) return b;
	p.Write(s);
	return b;
}

void ConsoleCtrl::Read()
{
	String s;
	p.Read(s);
	if(s.IsEmpty()) return;
	Insert(GetCursor(), s);
	SetCursor(GetCursor()+s.GetLength());
}

ConsoleCtrl::ConsoleCtrl(const String& cmd)
{
	OverWriteMode();
	ProcessEnter().ProcessTab();
	in.OverWriteMode();
	in.ProcessEnter().ProcessTab();	
	
	p.Start(cmd);
	SetTimeCallback (-50, THISBACK(Read));
}

ConsoleCtrl::~ConsoleCtrl()
{
	p.Kill();
}
