/*
    Copyright (c) 2007-2010 iMatix Corporation

    This file is part of 0MQ.

    0MQ is free software; you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    0MQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ZMQ_PLATFORM_HPP_INCLUDED__
#define __ZMQ_PLATFORM_HPP_INCLUDED__

//  This is the platform definition for the MSVC platform.
//  As a first step of the build process it is copied to
//  zmq directory to take place of platform.hpp generated from
//  platform.hpp.in on platforms supported by GNU autotools.
//  Place any MSVC-specific definitions here.

//#define ZMQ_HAVE_WINDOWS


//#include <Core/config.h>
#include <Core/Core.h>

#undef ZMQ_HAVE_WINDOWS
#undef ZMQ_HAVE_LINUX
#undef ZMQ_HAVE_SOLARIS
#undef ZMQ_HAVE_FREEBSD
#undef ZMQ_HAVE_OSX
#undef ZMQ_HAVE_NETBSD
#undef ZMQ_HAVE_OPENBSD
#undef ZMQ_HAVE_AIX
#undef ZMQ_HAVE_HPUX
#undef ZMQ_HAVE_MINGW32
#undef ZMQ_HAVE_CYGWIN

#if defined(PLATFORM_WIN32) && PLATFORM_WIN32
	#define ZMQ_HAVE_WINDOWS 1
#elif defined(PLATFORM_LINUX)
	#define ZMQ_HAVE_LINUX 1
#elif defined(PLATFORM_SOLARIS)
	#define ZMQ_HAVE_SOLARIS 1
#elif defined(PLATFORM_FREEBSD)
	#define ZMQ_HAVE_FREEBSD 1
#elif defined(__APPLE__)
	#define ZMQ_HAVE_OSX 1
#elif defined(PLATFORM_NETBSD)
	#define ZMQ_HAVE_NETBSD 1
#elif defined(PLATFORM_OPENBSD)
	#define ZMQ_HAVE_OPENBSD 1
#elif defined(PLATFORM_AIX)
	#define ZMQ_HAVE_AIX 1
#elif defined(PLATFORM_HPUX)
	#define ZMQ_HAVE_HPUX 1
#elif defined(COMPILER_MINGW)
	#define ZMQ_HAVE_MINGW32 1
#elif defined(PLATFORM_CYGWIN)
	#define ZMQ_HAVE_CYGWIN 1  
#endif


#endif
