#include "essaiStatusBar.h"

#define IMAGECLASS qsEssaiSb
#define IMAGEFILE <essaiStatusBar/essaiStatusBar.iml>
#include <Draw/iml.h>

void essaiDisplay::setStatus(bool flag)
{
	connected = flag;
}

void essaiDisplay::Paint(Draw& w,const Rect& r,const Value& q,Color ink,Color paper,dword style)const
{
	if(!connected)w.DrawImage(r,qsEssaiSb::qsNonConnected);
		else w.DrawImage(r,qsEssaiSb::qsConnected);
}


void essaiStatusBarMainWin::stateAction()
{
	if(PromptYesNo("Enable connection?")==1)firstDisplay.setStatus(true);
	   else firstDisplay.setStatus(false);
   
}

essaiStatusBarMainWin::essaiStatusBarMainWin()
{
	CtrlLayout(*this, "SetStatusBar");
	SetRect(10,10,400,300);
	Sizeable().Zoomable().CenterScreen();
	Icon(qsEssaiSb::qsUsers);
	
	firstDisplay.setStatus(false);
	first.Set(PaintRect(firstDisplay));
	essaiSb.AddFrame(first.Left(30));
	AddFrame(essaiSb);
	AddFrame(BottomSeparatorFrame());
	
	stateButton<<=THISBACK(stateAction);
}

GUI_APP_MAIN
{
	SetLanguage(GetSystemLNG());
	essaiStatusBarMainWin().Run();
}

