#ifndef _canvas_CanvasView_h_
#define _canvas_CanvasView_h_

//#include "Canvas.h"
#include "CanvasEventListener.h"
#include "Connector.h"
#include "Point.h"
#include "Rect.h"
#include "Selection.h"
#include "UppCanvas.h"
#include "MTDrag.h"
#include "MTConnect.h"
#include "HighLight.h"
#include "MTPick.h"
#include "MTracker.h"

namespace gm { 
	class Command;
	class ClassDiagram;
	class Handler;
}

namespace cv{

	class Tool; // need this?
	class EditorDialog;
	
	// I'm responsible of displaying a set of canvas into a CanvasCtrl
	// 
	// -- moveRelative
	// to avoid query/stating the list of incoming/outcoming
	// connections --> try to dispatch MOVERELATIVE to involved
	// connectors from the top (i.e.: those connectors are not selected,
	// but get dispatched too)
	//##ModelId=4D60563300EB
	class Diagram : public Canvas, public UppCanvas 
	{
		public:

    // Holds the state of debugging functions
    //##ModelId=4D711F2C0157
    struct CVDebug
    {
      public:
        //##ModelId=4D711FB20177
        CVDebug();

        //##ModelId=4D711F9F006D
        bool showDiagramBounds;
    };

	
    //##ModelId=4D6EDB6C02BF
		typedef Diagram CLASSNAME;

    //##ModelId=4D714D5E007D
    Connector* nearestConnector(Point p);

		
		//##ModelId=4D6056330237
		Diagram();
		
    //##ModelId=4D6CC7C0031C
    void show();
	    
		//##ModelId=4D6056330226
		vector<Tool*> tools;
		
		//##ModelId=4D6056330227
		vector<Canvas*> parts;
		
		//##ModelId=4D6056330229
		Selection selection;
		
		//##ModelId=4D605633022E
		Tool * picker;
		//##ModelId=4D72A98400FB
		Tool* relativePicker;
		//##ModelId=4D6056330233
		Tool *connector;
		//##ModelId=4D6D1BC0004F
		Tool *dragger;
    //##ModelId=4D77207802DF
		Tool *highLighter;
    //##ModelId=4D77312A031D
		Tool* tracker;
		
		//##ModelId=4D6D09B803BA
		CanvasEventListener listener;
		//##ModelId=4D711F500399
		CVDebug debug;
		
		// whether a draggin or handling operation is occurring
    //##ModelId=4D72F02A031C
		bool isDragging();
		
		//##ModelId=4D653E760119
		void setCursor(std::string name);
		
		//##ModelId=4D631B610157
		void moveInFront(Canvas* c);
		
		//##ModelId=4D6056330239
		void notify(Event* );
		
		//##ModelId=4D605633023B
		void paint();
		
		// bounds get evaluated during paint()
		//##ModelId=4D71253300AB
		Rect& bounds(){ return _bounds; }
		
		//##ModelId=4D605633023C
		void add(Tool* );
		
		//##ModelId=4D605633023E
		void add(Canvas* );
		
		//##ModelId=4D6056330240
		inline bool isView() {return true;}
		
		// protocol: model-view
		//##ModelId=4D63F536001F
		void startWiring(Connector* cn);
		//##ModelId=4D713A89030D
		void remove(Canvas* c);
		//##ModelId=4D7151BC02FD
		void selectConnectorRelativePoint(gm::Handler* m);
		
		// BUGGED
		//##ModelId=4D73BEE4002E
		void selectTree(Canvas* c);
		
    // same as add, but attach the canvas to the mouse
    //##ModelId=4D74A53301A5
    virtual void openInHand(Canvas* c);
    //##ModelId=4D74AF9E0119
    void selectAll();
    //##ModelId=4D74B9B80196
    bool isWiring();

    // the cursor is over one connector head or tail (the cursor-icon
    // should denote this)
    //##ModelId=4D74BC2602DE
    bool isReadyToWiring();
    //##ModelId=4D74C0BA02EE
    void clear();
    //##ModelId=4D74D8790138
    bool isPicking();
    //##ModelId=4D7578BB035B
    Canvas* lookupSole(gm::Handler* m);
    //##ModelId=4D770BE102EE
    MTDrag* get_dragger();
    //##ModelId=4D770C820138
    MTConnect* get_connector();
    //##ModelId=4D7721000222
    HighLight* get_highLighter();
    //##ModelId=4D772897001F
    MTPick* get_picker();
    //##ModelId=4D7731C70148
    MTracker* get_tracker();





	private:
	
		//##ModelId=4D62226901F4
		void initialize();
		//##ModelId=4D71229F0186
		Rect _bounds;
	};
}

#endif
