#ifndef _canvas_UppCanvas_h_
#define _canvas_UppCanvas_h_

#include <Painter/Painter.h>

#include "geometry.h"
#include "Rect.h"
#include "canvas.h"

namespace cv {

	class Text;

	//##ModelId=4D605633016A
	class UppCanvas {
  public:
  
		//##ModelId=4D605633037C
		Upp::Painter * _draw;
		
		//##ModelId=4D605633037D
		inline UppCanvas(Upp::Painter * d) :_draw(d){/**/};
		
		//##ModelId=4D605633037F
		void drawCircle(Point center,float radius,int lineWidth,Upp::Color);
		
		//##ModelId=4D6056330384
		void drawLine(Point start, Point end, int width, Upp::Color c = Upp::Black);
		
		//##ModelId=4D6056330389
		void drawLine(float , float , float , float , int width, Upp::Color c = Upp::Black, float angle=0, float x=0, float y=0);

		//##ModelId=4D6056330393
		void drawPoly(Rect r, int lineWidth, Upp::Color borderColor=Upp::Black	, Upp::Color fillColor=Upp::White);
    //##ModelId=4D6312F0035B
		void drawEmptyPoly(Rect& r, int lineWidth, Upp::Color c=Upp::Black);
			
		//##ModelId=4D6056330397
		void drawImage(float x, float y, Upp::Image , float alpha);
		
    //##ModelId=4D65522300BB
		void drawRoundRectangle(Rect r, float radius, int lineWidth=1, Upp::Color borderColor=Upp::Black);
		
    //##ModelId=4D622CC50280
    Point textSize(std::string text);

    //##ModelId=4D6228180213
    void drawText(Text* text);
    
    //##ModelId=4D653F700222
    void setCursor(std::string);

    //##ModelId=4D62440D0251
    void drawEllipse(float x,float y,float cx,float cy,Upp::Color color=Upp::Black, int lineWidth=1);

	};

}
#endif
