#include "Arrow.h"
#include "UppCanvas.h"
#include <CtrlCore/CtrlCore.h>

namespace cv {

	//##ModelId=4D60563301B8
	Arrow::Arrow(Canvas* c,ArrowType t)
		:Canvas(c)
		,type(t)
		{}

	//##ModelId=4D60563301BD
	void Arrow::paint(){ paint(0); }
	
	//##ModelId=4D60563301BB
	void Arrow::paint(float rotation){
		UppCanvas* d=root();
		int x1,y1, x2,y2, x3,y3, x4,y4;
		int size;
		switch(type){
			case None:
				break;
			case ClosedFilled:
			case ClosedEmpty:
				x1=origin.x ;
				y1=origin.y ;
				x2=origin.x + 12;
				y2=origin.y - 5;
				x3=origin.x + 12;
				y3=origin.y + 5; 
				d->drawLine(x1,y1,x2,y2,1,Upp::Black , rotation ,x1,y1);
				d->drawLine(x1,y1,x3,y3,1,Upp::Black , rotation ,x1,y1);
				d->drawLine(x3,y3,x2,y2,1,Upp::Black , rotation ,x1,y1);
				break;
			case DiamondEmpty:
  		case DiamondFilled:
			/*                                    
		        /\p2                         \p2
		       /  \                           \ 
		    p1/    \p3   ---------------------- p1
		      \    /                          /
		       \  /                         /p3
		        \/p4   
			*/
				x1=origin.x ;
				y1=origin.y ;
				x2=origin.x + 10;
				y2=origin.y - 5;
				x3=origin.x + 20;
				y3=origin.y ; 
				x4=origin.x + 10;
				y4=origin.y + 5;
				d->drawLine(x1,y1,x2,y2,1,Upp::Black , rotation ,x1,y1);
				d->drawLine(x2,y2,x3,y3,1,Upp::Black , rotation ,x1,y1);
				d->drawLine(x3,y3,x4,y4,1,Upp::Black , rotation ,x1,y1);
				d->drawLine(x4,y4,x1,y1,1,Upp::Black , rotation ,x1,y1);
				break;
			case OpenArrow:
				x1=origin.x;
				y1=origin.y;
				x2=origin.x - 12;
				y2=origin.y - 5;
				x3=origin.x - 12;
				y3=origin.y + 5;
				d->drawLine(x1,y1,x2,y2,1,Upp::Black , rotation ,x1,y1);
				d->drawLine(x1,y1,x3,y3,1,Upp::Black , rotation ,x1,y1);
		}

	}
	
}