#include "assert.h"

#include "Diagram.h"

#include "macros.h"
#include "shape.h"

// test
#include "Canvas.h"
#include "Ellipse.h"
#include "Group.h"
#include "HighLight.h"
#include "MTConnect.h"
#include "MTCursor.h"
#include "MTDrag.h"
#include "MTPick.h"
#include "MTPickRelative.h"
#include "Text.h"
#include "Separator.h"

#include "ConnectorEnd.h"
#include "Command.h"
#include "DiagramEditor.h"
#include "Handler.h"

namespace cv{

	//##ModelId=4D714D5E007D
	Connector* Diagram::nearestConnector(Point p) {
		Connector* c=NULL;
		double d=999999;
		each(Canvas,parts){
			if ((*i)->isConnector()){
				double d2=(*i)->distance(p);
				if (d2<d){
					d=d2;
					c= dynamic_cast<Connector*>(*i);
				}
			}
		}
		return c;
	}

	//##ModelId=4D62226901F4
	void Diagram::initialize()
	{
			tracker = new MTracker(this);
			picker=new MTPick(this);
			relativePicker=new MTPickRelative(this);
			connector=new MTConnect(this);
			dragger=new MTDrag(this);
			highLighter = new HighLight(this);

			add(tracker);
			add(connector);
			add(picker); // must work before MTDrag
			add(relativePicker);
			add(dragger);
			add(highLighter);
	}

	//##ModelId=4D72F02A031C
	bool Diagram::isDragging(){
		return get_dragger()->state != MTDrag::idle;
	}
	
	//##ModelId=4D6056330237
	Diagram::Diagram()
		:Canvas(NULL)
		,UppCanvas(NULL)
		{
			listener.destination=this;
			initialize();
		}

	//##ModelId=4D631B610157
	void Diagram::moveInFront(Canvas* c){
		each(Canvas,parts){ 
			if ((*i) == c) {
				parts.erase(i);
				break;
			}
		}
		parts.push_back(c);
	}

	//##ModelId=4D605633023C
	void Diagram::add(Tool* t){
		tools.push_back(t);
	}

	//##ModelId=4D74A53301A5
	void Diagram::openInHand(Canvas* c) {
		add(c);
		get_dragger()->startHandling(c);
	}

	//##ModelId=4D605633023E
	void Diagram::add(Canvas* t){
		each(Canvas,parts)
			if (*i == t) return;
		parts.push_back(t);
		if (!t->isConnector())
			t->move(get_tracker()->pt);
	}

	//##ModelId=4D605633023B
	void Diagram::paint(){

		_bounds.Set(999999,999999,0,0);
		_draw->Clear(Upp::White());
		
		each(Canvas,parts) 
			if ((*i)->visible && !(*i)->group){
				(*i)->paint();
				(*i)->setFlag(true); // moveRelative avoid multiple dispatch
				_bounds += (*i)->bounds();
			}
		_bounds += 3;
		
		if (debug.showDiagramBounds){
			_draw->DrawLine(_bounds.left,0,_bounds.left,1000,Upp::PEN_DASH,Upp::WhiteGray());
			_draw->DrawLine(_bounds.right,0,_bounds.right,1000,Upp::PEN_DASH,Upp::WhiteGray());
			_draw->DrawLine(0,_bounds.top,1000,_bounds.top,Upp::PEN_DASH,Upp::WhiteGray());
			_draw->DrawLine(0,_bounds.bottom,1000,_bounds.bottom,Upp::PEN_DASH,Upp::WhiteGray());
		}
		
		each(Tool,tools) 	
			(*i)->paint();
			
#if 1
		{
			Point display = Point(3,3);
			Upp::String s = Upp::Format("%d canvas" , (int) parts.size());
			_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
			display.y += 10;
			if (selection.size()>0){
				
				s = Upp::Format("%d selected" , selection.size());
				_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
				display.y += 10;
				
				if (selection.size() == 1){
					Canvas* c = selection.at(0);
					if (c->isShape()){
						
						s = Upp::Format("%d in, %d out" , (int)c->incoming.size() , (int)c->outcoming.size());
						_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
						display.y += 10;
						
					}
				}
			}
		}
#endif
	}
	
	//##ModelId=4D6056330239
	void Diagram::notify(Event* evt){
		if (evt->isMouseEvent()){
			evt->subjects.clear();
			each(Canvas,parts){
				if ((*i)->visible){
					(*i)->selected=(*i)->contains(evt->pt);
					if ((*i)->selected)
						evt->subjects.push_back(*i);
				}
			}
			each(Canvas,evt->subjects) 
				moveInFront(*i);
		}
		each(Tool,tools)
			if ((*i)->notify(evt)) 
				break;
		delete evt;
	}
	
	//##ModelId=4D653E760119
 	void Diagram::setCursor(std::string name){
		UppCanvas::setCursor(name);
	}

	//##ModelId=4D63F536001F
	void Diagram::startWiring(Connector* cn){
		add(cn);
		((MTConnect*)connector)->startWiring(cn);
	}

  //##ModelId=4D6CC7C0031C
  void Diagram::show(){
  }

	//##ModelId=4D713A89030D
	void Diagram::remove(Canvas* c) {
		each(Canvas,parts)
			if ((*i) == c){
				parts.erase(i);
				break;
			}
		selection.remove(c);
	}

	//##ModelId=4D711FB20177
	Diagram::CVDebug::CVDebug()
		: showDiagramBounds(true)
	{/**/}

	//##ModelId=4D7151BC02FD
	void Diagram::selectConnectorRelativePoint(gm::Handler* m) {
		setCursor("img_label");
		((MTPickRelative*)relativePicker)->startPickingRelative(m);
	}


	//##ModelId=4D73BEE4002E
	void Diagram::selectTree(Canvas* c) {
		Connector* cn;
		each(Canvas,parts){
			if ((*i)->isConnector()){
				cn = (Connector*) *i;
				if (!cn->head->isFree())
					if (cn->head->canvas == c)
						selection.add(cn);
				if (!cn->tail->isFree())
					if (cn->tail->canvas == c)
						selection.add(cn);
			}
		}
	}

	//##ModelId=4D74AF9E0119
	void Diagram::selectAll() {
		each(Canvas,parts)
			selection.add(*i);
		selection.persistent = true;
	}

	//##ModelId=4D74B9B80196
	bool Diagram::isWiring() {
		return ((MTConnect*) connector)->state != MTConnect::idle;
	}
	
	//##ModelId=4D74D8790138
	bool Diagram::isPicking() { return relativePicker->isActive(); }

	//##ModelId=4D74BC2602DE
	bool Diagram::isReadyToWiring() {return get_picker()->isReadyToWiring();}

	//##ModelId=4D74C0BA02EE
	void Diagram::clear() {
		while(selection.size())
			selection.at(0)->remove();
	}

	//##ModelId=4D7578BB035B
	Canvas* Diagram::lookupSole(gm::Handler* m) {
		Canvas* found=NULL;
		each(Canvas,parts)
			if ((*i)->player == m)
				if (found)
					throw "more than one";
				else
					found = *i;
		assert(found);
		return found;
	}

	//##ModelId=4D770BE102EE
	MTDrag* Diagram::get_dragger() { return dynamic_cast<MTDrag*>(dragger); }

	//##ModelId=4D770C820138
	MTConnect* Diagram::get_connector() { return dynamic_cast<MTConnect*>(connector); }

	//##ModelId=4D7721000222
	HighLight* Diagram::get_highLighter() { return dynamic_cast<HighLight*>(highLighter); }

	//##ModelId=4D772897001F
	MTPick* Diagram::get_picker() { return dynamic_cast<MTPick*>(picker); }

	//##ModelId=4D7731C70148
	MTracker* Diagram::get_tracker() { return dynamic_cast<MTracker*>(tracker); }
	
}




