#include "Ruler.h"

namespace cv {
//##ModelId=4D6F495A0139
	void Ruler::Paint(Upp::Draw& d){
		Upp::Size sz=GetSize();
		d.DrawRect(0,0,sz.cx,sz.cy,Upp::White());
		isHorizontal = sz.cx>sz.cy;
		if (isHorizontal){
			d.DrawLine(cursor.x,0,cursor.x,sz.cy,1);
			d.DrawText(cursor.x+3,0,Upp::Format("%2n" ,cursor.x));
			Upp::Font fnt=Upp::StdFont().Height(2);
			for(double xx=0; xx<sz.cx; xx+=100)
			{
				double dist=xx-cursor.x;
				if ((dist>30) || (dist<-30))
				{
					d.DrawLine(xx,0,xx,sz.cy);
					d.DrawText(xx+3,0,Upp::Format("%2n" ,xx));
				}
			}
		}else{
			d.DrawLine(0,cursor.y,sz.cx,cursor.y,1);
			d.DrawText(0,cursor.y+3,Upp::Format("%2n" ,cursor.y));
			for(double yy=0; yy<sz.cy; yy+=100)
			{
				double dist=yy-cursor.y;
				if ((dist>30) || (dist<-30))
				{
					d.DrawLine(0,yy,sz.cx,yy);
					d.DrawText(0,yy+3,Upp::Format("%2n" ,yy));
				}
			}
		}
		
	}
//##ModelId=4D6F495A013B
	void Ruler::set(Point p) {cursor=p; Refresh(); }
}
