#ifndef CV_TOOL_H
#define CV_TOOL_H

#include "geometry.h"
#include "canvas.h"

namespace cv {

	class Canvas;
	class Diagram;
	class Event;
 
	//##ModelId=4D6056330169
	class Tool {
	  public:
	    //##ModelId=4D6056330369
	    bool active;
	
	    //##ModelId=4D605633036B
	    Diagram * diagram;
	
	    //##ModelId=4D6056330370
	    Point pt;
    //##ModelId=4D74AD4E008C
    bool enabled;

	
	    //##ModelId=4D6056330374
	    Tool(Diagram* c) 
	    	:	diagram(c) 
	    	, active(false)
	    	, enabled(true)
	    {/**/}
	
	    //##ModelId=4D6056330376
	    virtual bool notify(Event* evt) { return false; };
	
	    //##ModelId=4D6056330379
	    virtual void paint();
	    
		//##ModelId=4D654DB50261
		virtual void finished();
		
    // whether this tool is working or not
    //##ModelId=4D6D1C9400FA
    virtual bool isActive();

    //##ModelId=4D6D1D12031C
    virtual void setActive(bool value);
    //##ModelId=4D74AD6203D8
    void setEnabled(bool value);

	
	};

} // namespace cv
#endif
